///------------------------------------------------------------------------
/// @file   NewProject.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_NewProject_H__ )
#define __SR_NewProject_H__

namespace surfride { 
namespace header { 

// V[
enum NewProject_Scenes
{
	Scene_NewProject_Root												= sr_scn_ofs * 1,
};

// C[
enum NewProject_Layers
{
	Layer_NewProject_Root_mz_ami												= Scene_NewProject_Root | sr_lyr_ofs * 1,
	Layer_NewProject_Root_mask												= Scene_NewProject_Root | sr_lyr_ofs * 2,
};

// Aj[V
enum NewProject_Animations
{
	Animation_NewProject_Root_mz_ami_norm_stan_loop												= Layer_NewProject_Root_mz_ami | sr_anm_ofs * 1,
	Animation_NewProject_Root_mz_ami_norm_tere												= Layer_NewProject_Root_mz_ami | sr_anm_ofs * 2,
	Animation_NewProject_Root_mz_ami_norm_diff												= Layer_NewProject_Root_mz_ami | sr_anm_ofs * 3,
	Animation_NewProject_Root_mz_ami_puyo_smile												= Layer_NewProject_Root_mz_ami | sr_anm_ofs * 4,
	Animation_NewProject_Root_mz_ami_puyo_anger												= Layer_NewProject_Root_mz_ami | sr_anm_ofs * 5,
	Animation_NewProject_Root_mz_ami_hoe_think												= Layer_NewProject_Root_mz_ami | sr_anm_ofs * 6,
	Animation_NewProject_Root_mz_ami_hoe_doubt												= Layer_NewProject_Root_mz_ami | sr_anm_ofs * 7,
	Animation_NewProject_Root_mz_ami_attack												= Layer_NewProject_Root_mz_ami | sr_anm_ofs * 8,
	Animation_NewProject_Root_mz_ami_norm_sleep												= Layer_NewProject_Root_mz_ami | sr_anm_ofs * 9,
};

// LXg
enum NewProject_Casts
{
	Cast_NewProject_Root_mz_ami_loop												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 1,
	Cast_NewProject_Root_mz_ami_norm												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 2,
	Cast_NewProject_Root_mz_ami_norm_norm_legL												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 3,
	Cast_NewProject_Root_mz_ami_norm_norm_legR												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 4,
	Cast_NewProject_Root_mz_ami_norm_norm_face												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 5,
	Cast_NewProject_Root_mz_ami_norm_Null_norm_stan_ef												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 6,
	Cast_NewProject_Root_mz_ami_norm_Null_norm_tere_ef												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 7,
	Cast_NewProject_Root_mz_ami_norm_Null_norm_diff_ef												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 8,
	Cast_NewProject_Root_mz_ami_puyo												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 9,
	Cast_NewProject_Root_mz_ami_puyo_puyo_arm												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 10,
	Cast_NewProject_Root_mz_ami_puyo_puyo_body												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 11,
	Cast_NewProject_Root_mz_ami_puyo_puyo_face												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 12,
	Cast_NewProject_Root_mz_ami_puyo_Null_norm_smile_ef												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 13,
	Cast_NewProject_Root_mz_ami_puyo_Null_norm_anger_ef												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 14,
	Cast_NewProject_Root_mz_ami_think												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 15,
	Cast_NewProject_Root_mz_ami_think_think_face												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 16,
	Cast_NewProject_Root_mz_ami_think_Null_norm_think_ef												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 17,
	Cast_NewProject_Root_mz_ami_think_Null_norm_doubt_ef												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 18,
	Cast_NewProject_Root_mz_ami_attack												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 19,
	Cast_NewProject_Root_mz_ami_attack_attack_arm												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 20,
	Cast_NewProject_Root_mz_ami_attack_Null_norm_attack_ef												= Layer_NewProject_Root_mz_ami | sr_cst_ofs * 21,
	Cast_NewProject_Root_mask_move_point												= Layer_NewProject_Root_mask | sr_cst_ofs * 1,
	Cast_NewProject_Root_mask_move_point_mask												= Layer_NewProject_Root_mask | sr_cst_ofs * 2,
};

// t@XLXgĒ`
enum NewProject_Reference_Casts
{
};

// Aj[VZbg
enum NewProject_AnimationSets
{
};


// Ro[gNX
class NewProjectConverter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"Root",
	};

	const char* LayerNames[][3] = 
	{
		{
			"mz_ami",
			"mask",
		},
	};

	const char* AnimeNames[][3][10] = 
	{
		{
			{
				"norm_stan_loop",
				"norm_tere",
				"norm_diff",
				"puyo_smile",
				"puyo_anger",
				"hoe_think",
				"hoe_doubt",
				"attack",
				"norm_sleep",
			},
			{
			},
		},
	};

	const char* CastNames[][3][22] = 
	{
		{
			{
				"loop",
				"norm",
				"norm_legL",
				"norm_legR",
				"norm_face",
				"Null_norm_stan_ef",
				"Null_norm_tere_ef",
				"Null_norm_diff_ef",
				"puyo",
				"puyo_arm",
				"puyo_body",
				"puyo_face",
				"Null_norm_smile_ef",
				"Null_norm_anger_ef",
				"think",
				"think_face",
				"Null_norm_think_ef",
				"Null_norm_doubt_ef",
				"attack",
				"attack_arm",
				"Null_norm_attack_ef",
			},
			{
				"move_point",
				"mask",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

