///------------------------------------------------------------------------
/// @file   NewProject.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_NewProject_H__ )
#define __SR_NewProject_H__

namespace surfride { 
namespace header { 

// V[
enum NewProject_Scenes
{
	Scene_NewProject_Root												= sr_scn_ofs * 1,
};

// C[
enum NewProject_Layers
{
	Layer_NewProject_Root_mz_arl												= Scene_NewProject_Root | sr_lyr_ofs * 1,
};

// Aj[V
enum NewProject_Animations
{
	Animation_NewProject_Root_mz_arl_norm_stan_loop												= Layer_NewProject_Root_mz_arl | sr_anm_ofs * 1,
	Animation_NewProject_Root_mz_arl_norm_diff												= Layer_NewProject_Root_mz_arl | sr_anm_ofs * 2,
	Animation_NewProject_Root_mz_arl_puyo_smile												= Layer_NewProject_Root_mz_arl | sr_anm_ofs * 3,
	Animation_NewProject_Root_mz_arl_puyo_anger												= Layer_NewProject_Root_mz_arl | sr_anm_ofs * 4,
	Animation_NewProject_Root_mz_arl_surp_surp												= Layer_NewProject_Root_mz_arl | sr_anm_ofs * 5,
	Animation_NewProject_Root_mz_arl_surp_doubt												= Layer_NewProject_Root_mz_arl | sr_anm_ofs * 6,
	Animation_NewProject_Root_mz_arl_surp_tohoho												= Layer_NewProject_Root_mz_arl | sr_anm_ofs * 7,
	Animation_NewProject_Root_mz_arl_surp_diff												= Layer_NewProject_Root_mz_arl | sr_anm_ofs * 8,
	Animation_NewProject_Root_mz_arl_norm_hoe												= Layer_NewProject_Root_mz_arl | sr_anm_ofs * 9,
	Animation_NewProject_Root_mz_arl_norm_dis												= Layer_NewProject_Root_mz_arl | sr_anm_ofs * 10,
	Animation_NewProject_Root_mz_arl_norm_tele												= Layer_NewProject_Root_mz_arl | sr_anm_ofs * 11,
};

// LXg
enum NewProject_Casts
{
	Cast_NewProject_Root_mz_arl_loop												= Layer_NewProject_Root_mz_arl | sr_cst_ofs * 1,
	Cast_NewProject_Root_mz_arl_norm_body												= Layer_NewProject_Root_mz_arl | sr_cst_ofs * 2,
	Cast_NewProject_Root_mz_arl_norm_body_norm_face												= Layer_NewProject_Root_mz_arl | sr_cst_ofs * 3,
	Cast_NewProject_Root_mz_arl_norm_body_Null_norm_stan_ef												= Layer_NewProject_Root_mz_arl | sr_cst_ofs * 4,
	Cast_NewProject_Root_mz_arl_norm_body_Null_norm_diff_ef												= Layer_NewProject_Root_mz_arl | sr_cst_ofs * 5,
	Cast_NewProject_Root_mz_arl_puyo_body												= Layer_NewProject_Root_mz_arl | sr_cst_ofs * 6,
	Cast_NewProject_Root_mz_arl_puyo_body_puyo_face												= Layer_NewProject_Root_mz_arl | sr_cst_ofs * 7,
	Cast_NewProject_Root_mz_arl_puyo_body_puyo_arm												= Layer_NewProject_Root_mz_arl | sr_cst_ofs * 8,
	Cast_NewProject_Root_mz_arl_puyo_body_Null_puyo_diff_ef												= Layer_NewProject_Root_mz_arl | sr_cst_ofs * 9,
	Cast_NewProject_Root_mz_arl_puyo_body_Null_puyo_anger_ef												= Layer_NewProject_Root_mz_arl | sr_cst_ofs * 10,
	Cast_NewProject_Root_mz_arl_surp_body												= Layer_NewProject_Root_mz_arl | sr_cst_ofs * 11,
	Cast_NewProject_Root_mz_arl_surp_body_surp_face												= Layer_NewProject_Root_mz_arl | sr_cst_ofs * 12,
	Cast_NewProject_Root_mz_arl_surp_body_Null_surp_surp_ef												= Layer_NewProject_Root_mz_arl | sr_cst_ofs * 13,
	Cast_NewProject_Root_mz_arl_surp_body_Null_surp_doubt_ef												= Layer_NewProject_Root_mz_arl | sr_cst_ofs * 14,
	Cast_NewProject_Root_mz_arl_surp_body_Null_surp_tohoho_ef												= Layer_NewProject_Root_mz_arl | sr_cst_ofs * 15,
	Cast_NewProject_Root_mz_arl_surp_body_Null_surp_diff_ef												= Layer_NewProject_Root_mz_arl | sr_cst_ofs * 16,
};

// t@XLXgĒ`
enum NewProject_Reference_Casts
{
};

// Aj[VZbg
enum NewProject_AnimationSets
{
};


// Ro[gNX
class NewProjectConverter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"Root",
	};

	const char* LayerNames[][2] = 
	{
		{
			"mz_arl",
		},
	};

	const char* AnimeNames[][2][12] = 
	{
		{
			{
				"norm_stan_loop",
				"norm_diff",
				"puyo_smile",
				"puyo_anger",
				"surp_surp",
				"surp_doubt",
				"surp_tohoho",
				"surp_diff",
				"norm_hoe",
				"norm_dis",
				"norm_tele",
			},
		},
	};

	const char* CastNames[][2][17] = 
	{
		{
			{
				"loop",
				"norm_body",
				"norm_face",
				"Null_norm_stan_ef",
				"Null_norm_diff_ef",
				"puyo_body",
				"puyo_face",
				"puyo_arm",
				"Null_puyo_diff_ef",
				"Null_puyo_anger_ef",
				"surp_body",
				"surp_face",
				"Null_surp_surp_ef",
				"Null_surp_doubt_ef",
				"Null_surp_tohoho_ef",
				"Null_surp_diff_ef",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

