///------------------------------------------------------------------------
/// @file   NewProject.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_NewProject_H__ )
#define __SR_NewProject_H__

namespace surfride { 
namespace header { 

// V[
enum NewProject_Scenes
{
	Scene_NewProject_Root												= sr_scn_ofs * 1,
};

// C[
enum NewProject_Layers
{
	Layer_NewProject_Root_mz_car												= Scene_NewProject_Root | sr_lyr_ofs * 1,
};

// Aj[V
enum NewProject_Animations
{
	Animation_NewProject_Root_mz_car_norm_stan_loop												= Layer_NewProject_Root_mz_car | sr_anm_ofs * 1,
	Animation_NewProject_Root_mz_car_norm_poker												= Layer_NewProject_Root_mz_car | sr_anm_ofs * 2,
	Animation_NewProject_Root_mz_car_happy												= Layer_NewProject_Root_mz_car | sr_anm_ofs * 3,
};

// LXg
enum NewProject_Casts
{
	Cast_NewProject_Root_mz_car_loop												= Layer_NewProject_Root_mz_car | sr_cst_ofs * 1,
	Cast_NewProject_Root_mz_car_norm_stan												= Layer_NewProject_Root_mz_car | sr_cst_ofs * 2,
	Cast_NewProject_Root_mz_car_norm_stan_face_stan												= Layer_NewProject_Root_mz_car | sr_cst_ofs * 3,
	Cast_NewProject_Root_mz_car_norm_stan_Null_norm_stan_ef												= Layer_NewProject_Root_mz_car | sr_cst_ofs * 4,
	Cast_NewProject_Root_mz_car_norm_poker												= Layer_NewProject_Root_mz_car | sr_cst_ofs * 5,
	Cast_NewProject_Root_mz_car_norm_poker_face_poker												= Layer_NewProject_Root_mz_car | sr_cst_ofs * 6,
	Cast_NewProject_Root_mz_car_norm_poker_Null_norm_poker_ef												= Layer_NewProject_Root_mz_car | sr_cst_ofs * 7,
	Cast_NewProject_Root_mz_car_happy												= Layer_NewProject_Root_mz_car | sr_cst_ofs * 8,
	Cast_NewProject_Root_mz_car_happy_mimi												= Layer_NewProject_Root_mz_car | sr_cst_ofs * 9,
	Cast_NewProject_Root_mz_car_happy_Null_happy_ef												= Layer_NewProject_Root_mz_car | sr_cst_ofs * 10,
};

// t@XLXgĒ`
enum NewProject_Reference_Casts
{
};

// Aj[VZbg
enum NewProject_AnimationSets
{
};


// Ro[gNX
class NewProjectConverter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"Root",
	};

	const char* LayerNames[][2] = 
	{
		{
			"mz_car",
		},
	};

	const char* AnimeNames[][2][4] = 
	{
		{
			{
				"norm_stan_loop",
				"norm_poker",
				"happy",
			},
		},
	};

	const char* CastNames[][2][11] = 
	{
		{
			{
				"loop",
				"norm_stan",
				"face_stan",
				"Null_norm_stan_ef",
				"norm_poker",
				"face_poker",
				"Null_norm_poker_ef",
				"happy",
				"mimi",
				"Null_happy_ef",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

