///------------------------------------------------------------------------
/// @file   NewProject.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_NewProject_H__ )
#define __SR_NewProject_H__

namespace surfride { 
namespace header { 

// V[
enum NewProject_Scenes
{
	Scene_NewProject_Root												= sr_scn_ofs * 1,
};

// C[
enum NewProject_Layers
{
	Layer_NewProject_Root_mz_eco_l												= Scene_NewProject_Root | sr_lyr_ofs * 1,
	Layer_NewProject_Root_mask												= Scene_NewProject_Root | sr_lyr_ofs * 2,
};

// Aj[V
enum NewProject_Animations
{
	Animation_NewProject_Root_mz_eco_l_norm_stan_loop												= Layer_NewProject_Root_mz_eco_l | sr_anm_ofs * 1,
	Animation_NewProject_Root_mz_eco_l_norm_bored_loop												= Layer_NewProject_Root_mz_eco_l | sr_anm_ofs * 2,
	Animation_NewProject_Root_mz_eco_l_high_loop												= Layer_NewProject_Root_mz_eco_l | sr_anm_ofs * 3,
};

// LXg
enum NewProject_Casts
{
	Cast_NewProject_Root_mz_eco_l_loop												= Layer_NewProject_Root_mz_eco_l | sr_cst_ofs * 1,
	Cast_NewProject_Root_mz_eco_l_ef												= Layer_NewProject_Root_mz_eco_l | sr_cst_ofs * 2,
	Cast_NewProject_Root_mz_eco_l_ef_ef01												= Layer_NewProject_Root_mz_eco_l | sr_cst_ofs * 3,
	Cast_NewProject_Root_mz_eco_l_ef_ef02												= Layer_NewProject_Root_mz_eco_l | sr_cst_ofs * 4,
	Cast_NewProject_Root_mz_eco_l_ef_ef03												= Layer_NewProject_Root_mz_eco_l | sr_cst_ofs * 5,
	Cast_NewProject_Root_mz_eco_l_ef_ef04												= Layer_NewProject_Root_mz_eco_l | sr_cst_ofs * 6,
	Cast_NewProject_Root_mz_eco_l_norm_stan												= Layer_NewProject_Root_mz_eco_l | sr_cst_ofs * 7,
	Cast_NewProject_Root_mz_eco_l_norm_stan_face_stan												= Layer_NewProject_Root_mz_eco_l | sr_cst_ofs * 8,
	Cast_NewProject_Root_mz_eco_l_norm_stan_hatena1												= Layer_NewProject_Root_mz_eco_l | sr_cst_ofs * 9,
	Cast_NewProject_Root_mz_eco_l_norm_stan_Null_norm_stan_ef												= Layer_NewProject_Root_mz_eco_l | sr_cst_ofs * 10,
	Cast_NewProject_Root_mz_eco_l_norm_bored												= Layer_NewProject_Root_mz_eco_l | sr_cst_ofs * 11,
	Cast_NewProject_Root_mz_eco_l_norm_bored_face_bored												= Layer_NewProject_Root_mz_eco_l | sr_cst_ofs * 12,
	Cast_NewProject_Root_mz_eco_l_norm_bored_hatena1												= Layer_NewProject_Root_mz_eco_l | sr_cst_ofs * 13,
	Cast_NewProject_Root_mz_eco_l_norm_bored_Null_norm_bored_ef												= Layer_NewProject_Root_mz_eco_l | sr_cst_ofs * 14,
	Cast_NewProject_Root_mz_eco_l_high												= Layer_NewProject_Root_mz_eco_l | sr_cst_ofs * 15,
	Cast_NewProject_Root_mz_eco_l_high_hatena1												= Layer_NewProject_Root_mz_eco_l | sr_cst_ofs * 16,
	Cast_NewProject_Root_mz_eco_l_high_Null_high_ef												= Layer_NewProject_Root_mz_eco_l | sr_cst_ofs * 17,
	Cast_NewProject_Root_mz_eco_l_core												= Layer_NewProject_Root_mz_eco_l | sr_cst_ofs * 18,
	Cast_NewProject_Root_mz_eco_l_core_core												= Layer_NewProject_Root_mz_eco_l | sr_cst_ofs * 19,
	Cast_NewProject_Root_mask_move_point												= Layer_NewProject_Root_mask | sr_cst_ofs * 1,
	Cast_NewProject_Root_mask_move_point_mask												= Layer_NewProject_Root_mask | sr_cst_ofs * 2,
};

// t@XLXgĒ`
enum NewProject_Reference_Casts
{
};

// Aj[VZbg
enum NewProject_AnimationSets
{
};


// Ro[gNX
class NewProjectConverter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"Root",
	};

	const char* LayerNames[][3] = 
	{
		{
			"mz_eco_l",
			"mask",
		},
	};

	const char* AnimeNames[][3][4] = 
	{
		{
			{
				"norm_stan_loop",
				"norm_bored_loop",
				"high_loop",
			},
			{
			},
		},
	};

	const char* CastNames[][3][20] = 
	{
		{
			{
				"loop",
				"ef",
				"ef01",
				"ef02",
				"ef03",
				"ef04",
				"norm_stan",
				"face_stan",
				"hatena1",
				"Null_norm_stan_ef",
				"norm_bored",
				"face_bored",
				"hatena1",
				"Null_norm_bored_ef",
				"high",
				"hatena1",
				"Null_high_ef",
				"core",
				"core",
			},
			{
				"move_point",
				"mask",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

