///------------------------------------------------------------------------
/// @file   NewProject.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_NewProject_H__ )
#define __SR_NewProject_H__

namespace surfride { 
namespace header { 

// V[
enum NewProject_Scenes
{
	Scene_NewProject_Root												= sr_scn_ofs * 1,
};

// C[
enum NewProject_Layers
{
	Layer_NewProject_Root_mz_rng_r												= Scene_NewProject_Root | sr_lyr_ofs * 1,
};

// Aj[V
enum NewProject_Animations
{
	Animation_NewProject_Root_mz_rng_r_norm_stan_loop												= Layer_NewProject_Root_mz_rng_r | sr_anm_ofs * 1,
	Animation_NewProject_Root_mz_rng_r_norm_smile												= Layer_NewProject_Root_mz_rng_r | sr_anm_ofs * 2,
	Animation_NewProject_Root_mz_rng_r_puyo_smile												= Layer_NewProject_Root_mz_rng_r | sr_anm_ofs * 3,
	Animation_NewProject_Root_mz_rng_r_puyo_anger												= Layer_NewProject_Root_mz_rng_r | sr_anm_ofs * 4,
	Animation_NewProject_Root_mz_rng_r_think_stan												= Layer_NewProject_Root_mz_rng_r | sr_anm_ofs * 5,
	Animation_NewProject_Root_mz_rng_r_think_diff												= Layer_NewProject_Root_mz_rng_r | sr_anm_ofs * 6,
	Animation_NewProject_Root_mz_rng_r_surp												= Layer_NewProject_Root_mz_rng_r | sr_anm_ofs * 7,
	Animation_NewProject_Root_mz_rng_r_norm_smile_loop												= Layer_NewProject_Root_mz_rng_r | sr_anm_ofs * 8,
};

// LXg
enum NewProject_Casts
{
	Cast_NewProject_Root_mz_rng_r_loop												= Layer_NewProject_Root_mz_rng_r | sr_cst_ofs * 1,
	Cast_NewProject_Root_mz_rng_r_norm_leg												= Layer_NewProject_Root_mz_rng_r | sr_cst_ofs * 2,
	Cast_NewProject_Root_mz_rng_r_norm_leg_norm_face												= Layer_NewProject_Root_mz_rng_r | sr_cst_ofs * 3,
	Cast_NewProject_Root_mz_rng_r_norm_leg_Null_norm_stan_ef												= Layer_NewProject_Root_mz_rng_r | sr_cst_ofs * 4,
	Cast_NewProject_Root_mz_rng_r_norm_leg_Null_norm_smile_ef												= Layer_NewProject_Root_mz_rng_r | sr_cst_ofs * 5,
	Cast_NewProject_Root_mz_rng_r_norm_leg_Null_norm_smile_loop_ef												= Layer_NewProject_Root_mz_rng_r | sr_cst_ofs * 6,
	Cast_NewProject_Root_mz_rng_r_puyo_leg												= Layer_NewProject_Root_mz_rng_r | sr_cst_ofs * 7,
	Cast_NewProject_Root_mz_rng_r_puyo_leg_puyo_face												= Layer_NewProject_Root_mz_rng_r | sr_cst_ofs * 8,
	Cast_NewProject_Root_mz_rng_r_puyo_leg_puyo_arm												= Layer_NewProject_Root_mz_rng_r | sr_cst_ofs * 9,
	Cast_NewProject_Root_mz_rng_r_puyo_leg_Null_puyo_smile_ef												= Layer_NewProject_Root_mz_rng_r | sr_cst_ofs * 10,
	Cast_NewProject_Root_mz_rng_r_puyo_leg_Null_puyo_anger_ef												= Layer_NewProject_Root_mz_rng_r | sr_cst_ofs * 11,
	Cast_NewProject_Root_mz_rng_r_think_body												= Layer_NewProject_Root_mz_rng_r | sr_cst_ofs * 12,
	Cast_NewProject_Root_mz_rng_r_think_body_think_face												= Layer_NewProject_Root_mz_rng_r | sr_cst_ofs * 13,
	Cast_NewProject_Root_mz_rng_r_think_body_Null_think_stan_ef												= Layer_NewProject_Root_mz_rng_r | sr_cst_ofs * 14,
	Cast_NewProject_Root_mz_rng_r_think_body_Null_think_diff_ef												= Layer_NewProject_Root_mz_rng_r | sr_cst_ofs * 15,
	Cast_NewProject_Root_mz_rng_r_surp												= Layer_NewProject_Root_mz_rng_r | sr_cst_ofs * 16,
	Cast_NewProject_Root_mz_rng_r_surp_Null_surp_ef												= Layer_NewProject_Root_mz_rng_r | sr_cst_ofs * 17,
};

// t@XLXgĒ`
enum NewProject_Reference_Casts
{
};

// Aj[VZbg
enum NewProject_AnimationSets
{
};


// Ro[gNX
class NewProjectConverter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"Root",
	};

	const char* LayerNames[][2] = 
	{
		{
			"mz_rng_r",
		},
	};

	const char* AnimeNames[][2][9] = 
	{
		{
			{
				"norm_stan_loop",
				"norm_smile",
				"puyo_smile",
				"puyo_anger",
				"think_stan",
				"think_diff",
				"surp",
				"norm_smile_loop",
			},
		},
	};

	const char* CastNames[][2][18] = 
	{
		{
			{
				"loop",
				"norm_leg",
				"norm_face",
				"Null_norm_stan_ef",
				"Null_norm_smile_ef",
				"Null_norm_smile_loop_ef",
				"puyo_leg",
				"puyo_face",
				"puyo_arm",
				"Null_puyo_smile_ef",
				"Null_puyo_anger_ef",
				"think_body",
				"think_face",
				"Null_think_stan_ef",
				"Null_think_diff_ef",
				"surp",
				"Null_surp_ef",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

