///------------------------------------------------------------------------
/// @file   NewProject.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_NewProject_H__ )
#define __SR_NewProject_H__

namespace surfride { 
namespace header { 

// V[
enum NewProject_Scenes
{
	Scene_NewProject_Root												= sr_scn_ofs * 1,
};

// C[
enum NewProject_Layers
{
	Layer_NewProject_Root_mz_star												= Scene_NewProject_Root | sr_lyr_ofs * 1,
};

// Aj[V
enum NewProject_Animations
{
	Animation_NewProject_Root_mz_star_norm_stan_loop												= Layer_NewProject_Root_mz_star | sr_anm_ofs * 1,
};

// LXg
enum NewProject_Casts
{
	Cast_NewProject_Root_mz_star_move_point												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 1,
	Cast_NewProject_Root_mz_star_move_point_star												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 2,
	Cast_NewProject_Root_mz_star_move_point_star_shuchu												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 3,
	Cast_NewProject_Root_mz_star_move_point_star_line_br_00												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 4,
	Cast_NewProject_Root_mz_star_move_point_star_line_br_01												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 5,
	Cast_NewProject_Root_mz_star_move_point_star_line_br_02												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 6,
	Cast_NewProject_Root_mz_star_move_point_star_line_br_03												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 7,
	Cast_NewProject_Root_mz_star_move_point_star_coa												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 8,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 9,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl_Cast_0022												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 10,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl_Cast_0023												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 11,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl_Cast_0024												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 12,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl_Cast_0025												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 13,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl1												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 14,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl1_Cast_0022												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 15,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl1_Cast_0023												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 16,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl1_Cast_0024												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 17,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl1_Cast_0025												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 18,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl2												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 19,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl2_Cast_0022												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 20,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl2_Cast_0023												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 21,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl2_Cast_0024												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 22,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl2_Cast_0025												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 23,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl3												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 24,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl3_Cast_0022												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 25,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl3_Cast_0023												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 26,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl3_Cast_0024												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 27,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl3_Cast_0025												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 28,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl4												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 29,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl4_Cast_0022												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 30,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl4_Cast_0023												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 31,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl4_Cast_0024												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 32,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl4_Cast_0025												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 33,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl5												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 34,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl5_Cast_0022												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 35,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl5_Cast_0023												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 36,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl5_Cast_0024												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 37,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl5_Cast_0025												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 38,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl6												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 39,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl6_Cast_0022												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 40,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl6_Cast_0023												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 41,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl6_Cast_0024												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 42,
	Cast_NewProject_Root_mz_star_move_point_star_ptcl6_Cast_0025												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 43,
	Cast_NewProject_Root_mz_star_move_point_star_star												= Layer_NewProject_Root_mz_star | sr_cst_ofs * 44,
};

// t@XLXgĒ`
enum NewProject_Reference_Casts
{
};

// Aj[VZbg
enum NewProject_AnimationSets
{
};


// Ro[gNX
class NewProjectConverter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"Root",
	};

	const char* LayerNames[][2] = 
	{
		{
			"mz_star",
		},
	};

	const char* AnimeNames[][2][2] = 
	{
		{
			{
				"norm_stan_loop",
			},
		},
	};

	const char* CastNames[][2][45] = 
	{
		{
			{
				"move_point",
				"star",
				"shuchu",
				"line_br_00",
				"line_br_01",
				"line_br_02",
				"line_br_03",
				"coa",
				"ptcl",
				"Cast_0022",
				"Cast_0023",
				"Cast_0024",
				"Cast_0025",
				"ptcl1",
				"Cast_0022",
				"Cast_0023",
				"Cast_0024",
				"Cast_0025",
				"ptcl2",
				"Cast_0022",
				"Cast_0023",
				"Cast_0024",
				"Cast_0025",
				"ptcl3",
				"Cast_0022",
				"Cast_0023",
				"Cast_0024",
				"Cast_0025",
				"ptcl4",
				"Cast_0022",
				"Cast_0023",
				"Cast_0024",
				"Cast_0025",
				"ptcl5",
				"Cast_0022",
				"Cast_0023",
				"Cast_0024",
				"Cast_0025",
				"ptcl6",
				"Cast_0022",
				"Cast_0023",
				"Cast_0024",
				"Cast_0025",
				"star",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

