///------------------------------------------------------------------------
/// @file   NewProject.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_NewProject_H__ )
#define __SR_NewProject_H__

namespace surfride { 
namespace header { 

// V[
enum NewProject_Scenes
{
	Scene_NewProject_Root												= sr_scn_ofs * 1,
};

// C[
enum NewProject_Layers
{
	Layer_NewProject_Root_mz_wch												= Scene_NewProject_Root | sr_lyr_ofs * 1,
	Layer_NewProject_Root_mask												= Scene_NewProject_Root | sr_lyr_ofs * 2,
};

// Aj[V
enum NewProject_Animations
{
	Animation_NewProject_Root_mz_wch_norm_stan_loop												= Layer_NewProject_Root_mz_wch | sr_anm_ofs * 1,
	Animation_NewProject_Root_mz_wch_norm_smile												= Layer_NewProject_Root_mz_wch | sr_anm_ofs * 2,
	Animation_NewProject_Root_mz_wch_norm_akire												= Layer_NewProject_Root_mz_wch | sr_anm_ofs * 3,
	Animation_NewProject_Root_mz_wch_read_read												= Layer_NewProject_Root_mz_wch | sr_anm_ofs * 4,
	Animation_NewProject_Root_mz_wch_read_diff												= Layer_NewProject_Root_mz_wch | sr_anm_ofs * 5,
	Animation_NewProject_Root_mz_wch_surp_surp												= Layer_NewProject_Root_mz_wch | sr_anm_ofs * 6,
	Animation_NewProject_Root_mz_wch_surp_anger												= Layer_NewProject_Root_mz_wch | sr_anm_ofs * 7,
};

// LXg
enum NewProject_Casts
{
	Cast_NewProject_Root_mz_wch_loop												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 1,
	Cast_NewProject_Root_mz_wch_norm_stan												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 2,
	Cast_NewProject_Root_mz_wch_norm_stan_face_stan												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 3,
	Cast_NewProject_Root_mz_wch_norm_stan_Null_norm_stan_ef												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 4,
	Cast_NewProject_Root_mz_wch_norm_smile												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 5,
	Cast_NewProject_Root_mz_wch_norm_smile_face_smile												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 6,
	Cast_NewProject_Root_mz_wch_norm_smile_Null_norm_smile_ef												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 7,
	Cast_NewProject_Root_mz_wch_norm_akire												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 8,
	Cast_NewProject_Root_mz_wch_norm_akire_face_akire												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 9,
	Cast_NewProject_Root_mz_wch_norm_akire_Null_norm_akire_ef												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 10,
	Cast_NewProject_Root_mz_wch_read_read												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 11,
	Cast_NewProject_Root_mz_wch_read_read_face_read												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 12,
	Cast_NewProject_Root_mz_wch_read_read_Null_read_read_ef												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 13,
	Cast_NewProject_Root_mz_wch_read_diff												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 14,
	Cast_NewProject_Root_mz_wch_read_diff_face_diff												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 15,
	Cast_NewProject_Root_mz_wch_read_diff_Null_read_diff_ef												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 16,
	Cast_NewProject_Root_mz_wch_surp_surp												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 17,
	Cast_NewProject_Root_mz_wch_surp_surp_face_surp												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 18,
	Cast_NewProject_Root_mz_wch_surp_surp_Null_surp_surp_ef												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 19,
	Cast_NewProject_Root_mz_wch_surp_anger												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 20,
	Cast_NewProject_Root_mz_wch_surp_anger_face_anger												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 21,
	Cast_NewProject_Root_mz_wch_surp_anger_Null_surp_anger_ef												= Layer_NewProject_Root_mz_wch | sr_cst_ofs * 22,
	Cast_NewProject_Root_mask_move_point												= Layer_NewProject_Root_mask | sr_cst_ofs * 1,
	Cast_NewProject_Root_mask_move_point_mask												= Layer_NewProject_Root_mask | sr_cst_ofs * 2,
};

// t@XLXgĒ`
enum NewProject_Reference_Casts
{
};

// Aj[VZbg
enum NewProject_AnimationSets
{
};


// Ro[gNX
class NewProjectConverter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"Root",
	};

	const char* LayerNames[][3] = 
	{
		{
			"mz_wch",
			"mask",
		},
	};

	const char* AnimeNames[][3][8] = 
	{
		{
			{
				"norm_stan_loop",
				"norm_smile",
				"norm_akire",
				"read_read",
				"read_diff",
				"surp_surp",
				"surp_anger",
			},
			{
			},
		},
	};

	const char* CastNames[][3][23] = 
	{
		{
			{
				"loop",
				"norm_stan",
				"face_stan",
				"Null_norm_stan_ef",
				"norm_smile",
				"face_smile",
				"Null_norm_smile_ef",
				"norm_akire",
				"face_akire",
				"Null_norm_akire_ef",
				"read_read",
				"face_read",
				"Null_read_read_ef",
				"read_diff",
				"face_diff",
				"Null_read_diff_ef",
				"surp_surp",
				"face_surp",
				"Null_surp_surp_ef",
				"surp_anger",
				"face_anger",
				"Null_surp_anger_ef",
			},
			{
				"move_point",
				"mask",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

