///------------------------------------------------------------------------
/// @file   v0100_event_info_00.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_v0100_event_info_00_H__ )
#define __SR_v0100_event_info_00_H__

namespace surfride { 
namespace header { 

// V[
enum v0100_event_info_00_Scenes
{
	Scene_v0100_event_info_00_v0100_event_info_00												= sr_scn_ofs * 1,
};

// C[
enum v0100_event_info_00_Layers
{
	Layer_v0100_event_info_00_v0100_event_info_00_event_base												= Scene_v0100_event_info_00_v0100_event_info_00 | sr_lyr_ofs * 1,
	Layer_v0100_event_info_00_v0100_event_info_00_Reference_bt_close												= Scene_v0100_event_info_00_v0100_event_info_00 | sr_lyr_ofs * 2,
};

// Aj[V
enum v0100_event_info_00_Animations
{
	Animation_v0100_event_info_00_v0100_event_info_00_event_base_All_in												= Layer_v0100_event_info_00_v0100_event_info_00_event_base | sr_anm_ofs * 1,
	Animation_v0100_event_info_00_v0100_event_info_00_event_base_Info_in												= Layer_v0100_event_info_00_v0100_event_info_00_event_base | sr_anm_ofs * 2,
	Animation_v0100_event_info_00_v0100_event_info_00_event_base_All_loop												= Layer_v0100_event_info_00_v0100_event_info_00_event_base | sr_anm_ofs * 3,
	Animation_v0100_event_info_00_v0100_event_info_00_event_base_All_out												= Layer_v0100_event_info_00_v0100_event_info_00_event_base | sr_anm_ofs * 4,
	Animation_v0100_event_info_00_v0100_event_info_00_Reference_bt_close_bt_Active												= Layer_v0100_event_info_00_v0100_event_info_00_Reference_bt_close | sr_anm_ofs * 1,
	Animation_v0100_event_info_00_v0100_event_info_00_Reference_bt_close_bt_Touch												= Layer_v0100_event_info_00_v0100_event_info_00_Reference_bt_close | sr_anm_ofs * 2,
	Animation_v0100_event_info_00_v0100_event_info_00_Reference_bt_close_bt_grey												= Layer_v0100_event_info_00_v0100_event_info_00_Reference_bt_close | sr_anm_ofs * 3,
};

// LXg
enum v0100_event_info_00_Casts
{
	Cast_v0100_event_info_00_v0100_event_info_00_event_base_move_point_0_0												= Layer_v0100_event_info_00_v0100_event_info_00_event_base | sr_cst_ofs * 1,
	Cast_v0100_event_info_00_v0100_event_info_00_event_base_move_point_0_0_anim_point												= Layer_v0100_event_info_00_v0100_event_info_00_event_base | sr_cst_ofs * 2,
	Cast_v0100_event_info_00_v0100_event_info_00_event_base_move_point_0_0_anim_point_ptn												= Layer_v0100_event_info_00_v0100_event_info_00_event_base | sr_cst_ofs * 3,
	Cast_v0100_event_info_00_v0100_event_info_00_event_base_move_point_0_0_anim_point_ptn_white												= Layer_v0100_event_info_00_v0100_event_info_00_event_base | sr_cst_ofs * 4,
	Cast_v0100_event_info_00_v0100_event_info_00_event_base_move_point_0_0_anim_point_info_dmy												= Layer_v0100_event_info_00_v0100_event_info_00_event_base | sr_cst_ofs * 5,
	Cast_v0100_event_info_00_v0100_event_info_00_event_base_move_point_0_0_anim_point_Reference_bt_close												= Layer_v0100_event_info_00_v0100_event_info_00_event_base | sr_cst_ofs * 6,
	Cast_v0100_event_info_00_v0100_event_info_00_Reference_bt_close_move_point												= Layer_v0100_event_info_00_v0100_event_info_00_Reference_bt_close | sr_cst_ofs * 1,
	Cast_v0100_event_info_00_v0100_event_info_00_Reference_bt_close_move_point_bt												= Layer_v0100_event_info_00_v0100_event_info_00_Reference_bt_close | sr_cst_ofs * 2,
	Cast_v0100_event_info_00_v0100_event_info_00_Reference_bt_close_move_point_bt_close												= Layer_v0100_event_info_00_v0100_event_info_00_Reference_bt_close | sr_cst_ofs * 3,
};

// t@XLXgĒ`
enum v0100_event_info_00_Reference_Casts
{
	RefCast_v0100_event_info_00_v0100_event_info_00_event_base_move_point_0_0_anim_point_Reference_bt_close												= Layer_v0100_event_info_00_v0100_event_info_00_event_base | sr_cst_ofs * 6,
};

// Aj[VZbg
enum v0100_event_info_00_AnimationSets
{
};


// Ro[gNX
class v0100_event_info_00Converter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"v0100_event_info_00",
	};

	const char* LayerNames[][3] = 
	{
		{
			"event_base",
			"Reference_bt_close",
		},
	};

	const char* AnimeNames[][3][5] = 
	{
		{
			{
				"All_in",
				"Info_in",
				"All_loop",
				"All_out",
			},
			{
				"bt_Active",
				"bt_Touch",
				"bt_grey",
			},
		},
	};

	const char* CastNames[][3][7] = 
	{
		{
			{
				"move_point_0_0",
				"anim_point",
				"ptn",
				"white",
				"info_dmy",
				"Reference_bt_close",
			},
			{
				"move_point",
				"bt",
				"close",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

