///------------------------------------------------------------------------
/// @file   v0100_matching_01.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_v0100_matching_01_H__ )
#define __SR_v0100_matching_01_H__

namespace surfride { 
namespace header { 

// V[
enum v0100_matching_01_Scenes
{
	Scene_v0100_matching_01_v0100_matching_01												= sr_scn_ofs * 1,
};

// C[
enum v0100_matching_01_Layers
{
	Layer_v0100_matching_01_v0100_matching_01_base												= Scene_v0100_matching_01_v0100_matching_01 | sr_lyr_ofs * 1,
	Layer_v0100_matching_01_v0100_matching_01_Reference_sort												= Scene_v0100_matching_01_v0100_matching_01 | sr_lyr_ofs * 2,
	Layer_v0100_matching_01_v0100_matching_01_Reference_favorite												= Scene_v0100_matching_01_v0100_matching_01 | sr_lyr_ofs * 3,
	Layer_v0100_matching_01_v0100_matching_01_Reference_bt_page_next												= Scene_v0100_matching_01_v0100_matching_01 | sr_lyr_ofs * 4,
	Layer_v0100_matching_01_v0100_matching_01_Reference_bt_page_back												= Scene_v0100_matching_01_v0100_matching_01 | sr_lyr_ofs * 5,
	Layer_v0100_matching_01_v0100_matching_01_Reference_icon_FOCUS												= Scene_v0100_matching_01_v0100_matching_01 | sr_lyr_ofs * 6,
};

// Aj[V
enum v0100_matching_01_Animations
{
	Animation_v0100_matching_01_v0100_matching_01_base_All_in												= Layer_v0100_matching_01_v0100_matching_01_base | sr_anm_ofs * 1,
	Animation_v0100_matching_01_v0100_matching_01_base_All_loop												= Layer_v0100_matching_01_v0100_matching_01_base | sr_anm_ofs * 2,
	Animation_v0100_matching_01_v0100_matching_01_base_All_out												= Layer_v0100_matching_01_v0100_matching_01_base | sr_anm_ofs * 3,
	Animation_v0100_matching_01_v0100_matching_01_base_favorite_mark_in												= Layer_v0100_matching_01_v0100_matching_01_base | sr_anm_ofs * 4,
	Animation_v0100_matching_01_v0100_matching_01_base_favorite_mark_loop												= Layer_v0100_matching_01_v0100_matching_01_base | sr_anm_ofs * 5,
	Animation_v0100_matching_01_v0100_matching_01_base_favorite_mark_out												= Layer_v0100_matching_01_v0100_matching_01_base | sr_anm_ofs * 6,
	Animation_v0100_matching_01_v0100_matching_01_base_card_in												= Layer_v0100_matching_01_v0100_matching_01_base | sr_anm_ofs * 7,
	Animation_v0100_matching_01_v0100_matching_01_Reference_sort_loop												= Layer_v0100_matching_01_v0100_matching_01_Reference_sort | sr_anm_ofs * 1,
	Animation_v0100_matching_01_v0100_matching_01_Reference_sort_sort_name												= Layer_v0100_matching_01_v0100_matching_01_Reference_sort | sr_anm_ofs * 2,
	Animation_v0100_matching_01_v0100_matching_01_Reference_sort_bt_next_active												= Layer_v0100_matching_01_v0100_matching_01_Reference_sort | sr_anm_ofs * 3,
	Animation_v0100_matching_01_v0100_matching_01_Reference_sort_bt_next_touch												= Layer_v0100_matching_01_v0100_matching_01_Reference_sort | sr_anm_ofs * 4,
	Animation_v0100_matching_01_v0100_matching_01_Reference_sort_bt_back_active												= Layer_v0100_matching_01_v0100_matching_01_Reference_sort | sr_anm_ofs * 5,
	Animation_v0100_matching_01_v0100_matching_01_Reference_sort_bt_back_touch												= Layer_v0100_matching_01_v0100_matching_01_Reference_sort | sr_anm_ofs * 6,
	Animation_v0100_matching_01_v0100_matching_01_Reference_favorite_bt_register_active												= Layer_v0100_matching_01_v0100_matching_01_Reference_favorite | sr_anm_ofs * 1,
	Animation_v0100_matching_01_v0100_matching_01_Reference_favorite_bt_register_touch												= Layer_v0100_matching_01_v0100_matching_01_Reference_favorite | sr_anm_ofs * 2,
	Animation_v0100_matching_01_v0100_matching_01_Reference_favorite_bt_register_grey												= Layer_v0100_matching_01_v0100_matching_01_Reference_favorite | sr_anm_ofs * 3,
	Animation_v0100_matching_01_v0100_matching_01_Reference_favorite_bt_release_active												= Layer_v0100_matching_01_v0100_matching_01_Reference_favorite | sr_anm_ofs * 4,
	Animation_v0100_matching_01_v0100_matching_01_Reference_favorite_bt_release_touch												= Layer_v0100_matching_01_v0100_matching_01_Reference_favorite | sr_anm_ofs * 5,
	Animation_v0100_matching_01_v0100_matching_01_Reference_bt_page_next_active												= Layer_v0100_matching_01_v0100_matching_01_Reference_bt_page_next | sr_anm_ofs * 1,
	Animation_v0100_matching_01_v0100_matching_01_Reference_bt_page_next_touch												= Layer_v0100_matching_01_v0100_matching_01_Reference_bt_page_next | sr_anm_ofs * 2,
	Animation_v0100_matching_01_v0100_matching_01_Reference_bt_page_next_grey												= Layer_v0100_matching_01_v0100_matching_01_Reference_bt_page_next | sr_anm_ofs * 3,
	Animation_v0100_matching_01_v0100_matching_01_Reference_bt_page_back_active												= Layer_v0100_matching_01_v0100_matching_01_Reference_bt_page_back | sr_anm_ofs * 1,
	Animation_v0100_matching_01_v0100_matching_01_Reference_bt_page_back_touch												= Layer_v0100_matching_01_v0100_matching_01_Reference_bt_page_back | sr_anm_ofs * 2,
	Animation_v0100_matching_01_v0100_matching_01_Reference_bt_page_back_grey												= Layer_v0100_matching_01_v0100_matching_01_Reference_bt_page_back | sr_anm_ofs * 3,
	Animation_v0100_matching_01_v0100_matching_01_Reference_icon_FOCUS_Focus_loop												= Layer_v0100_matching_01_v0100_matching_01_Reference_icon_FOCUS | sr_anm_ofs * 1,
};

// LXg
enum v0100_matching_01_Casts
{
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 1,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 2,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 3,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_base												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 4,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_base_base_00												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 5,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_base_base_00_kazari												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 6,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_base_base_00_title												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 7,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_base_base_01												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 8,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_base_base_02												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 9,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_base_clear												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 10,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_page												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 11,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_page_page_base												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 12,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_page_page_99_right												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 13,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_page_page_99_left												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 14,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_page_Reference_bt_page_next												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 15,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_page_Reference_bt_page_back												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 16,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_shoji												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 17,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_shoji_card_999_right												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 18,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_shoji_card_999_left												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 19,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_shoji_card_999_left_over												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 20,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 21,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_01												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 22,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_01_icon_base_000												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 23,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_01_icon_base_001												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 24,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_01_icon_base_002												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 25,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_01_icon_base_003												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 26,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_01_icon_base_004												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 27,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_01_icon_base_005												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 28,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_01_icon_base_006												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 29,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_01_icon_base_007												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 30,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_01_icon_base_008												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 31,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_01_icon_base_009												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 32,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_02												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 33,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_02_icon_base_000												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 34,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_02_icon_base_001												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 35,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_02_icon_base_002												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 36,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_02_icon_base_003												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 37,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_02_icon_base_004												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 38,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_02_icon_base_005												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 39,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_02_icon_base_006												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 40,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_02_icon_base_007												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 41,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_02_icon_base_008												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 42,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_02_icon_base_009												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 43,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_03												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 44,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_03_icon_base_000												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 45,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_03_icon_base_001												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 46,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_03_icon_base_002												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 47,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_03_icon_base_003												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 48,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_03_icon_base_004												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 49,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_03_icon_base_005												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 50,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_03_icon_base_006												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 51,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_03_icon_base_007												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 52,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_03_icon_base_008												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 53,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_base_03_icon_base_009												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 54,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 55,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_01												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 56,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_01_icon_001												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 57,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_01_icon_002												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 58,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_01_icon_003												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 59,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_01_icon_004												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 60,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_01_icon_005												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 61,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_01_icon_006												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 62,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_01_icon_007												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 63,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_01_icon_008												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 64,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_01_icon_009												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 65,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_01_icon_010												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 66,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_02												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 67,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_02_icon_001												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 68,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_02_icon_002												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 69,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_02_icon_003												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 70,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_02_icon_004												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 71,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_02_icon_005												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 72,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_02_icon_006												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 73,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_02_icon_007												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 74,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_02_icon_008												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 75,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_02_icon_009												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 76,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_02_icon_010												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 77,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_03												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 78,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_03_icon_001												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 79,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_03_icon_002												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 80,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_03_icon_003												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 81,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_03_icon_004												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 82,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_03_icon_005												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 83,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_03_icon_006												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 84,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_03_icon_007												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 85,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_03_icon_008												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 86,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_03_icon_009												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 87,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_icon_03_icon_010												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 88,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_Reference_sort												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 89,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_Reference_favorite												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 90,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 91,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_base												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 92,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_base_base_00												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 93,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_text												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 94,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_text_monster_name												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 95,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_text_monster_name_m_name_12												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 96,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_text_monster_name_m_name13_14												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 97,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_text_monster_name_m_name15_16												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 98,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_text_hissatsu												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 99,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_text_hissatsu_skill_name												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 100,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_text_hissatsu_mp_99												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 101,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_text_hissatsu_mp_99_mp_100												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 102,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_text_hissatsu_mp_99_mp_010												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 103,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_text_hissatsu_mp_99_mp_001												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 104,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_text_hissatsu_skill_info												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 105,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_text_hissatsu_hyphen												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 106,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_text_hissatsu_lv_99												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 107,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_text_hissatsu_lv_99_lv_10												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 108,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_text_hissatsu_lv_99_lv_01												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 109,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_text_otomo_koka												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 110,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_text_otomo_koka_skill_name												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 111,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_text_otomo_koka_skill_info												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 112,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_card												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 113,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_card_shadow												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 114,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_card_Refarence_card												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 115,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_card_favorite_mark												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 116,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_card_ef												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 117,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_card_ef_ef_giza												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 118,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_card_ef_ef_giza1												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 119,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_pick_up_base_card_ef_ef_giza2												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 120,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_info												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 121,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_info_info_base												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 122,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_info_info_text												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 123,
	Cast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_info_Reference_aco												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 124,
	Cast_v0100_matching_01_v0100_matching_01_Reference_sort_move_point_0_0												= Layer_v0100_matching_01_v0100_matching_01_Reference_sort | sr_cst_ofs * 1,
	Cast_v0100_matching_01_v0100_matching_01_Reference_sort_move_point_0_0_sort												= Layer_v0100_matching_01_v0100_matching_01_Reference_sort | sr_cst_ofs * 2,
	Cast_v0100_matching_01_v0100_matching_01_Reference_sort_move_point_0_0_sort_base												= Layer_v0100_matching_01_v0100_matching_01_Reference_sort | sr_cst_ofs * 3,
	Cast_v0100_matching_01_v0100_matching_01_Reference_sort_move_point_0_0_sort_now_sort_name												= Layer_v0100_matching_01_v0100_matching_01_Reference_sort | sr_cst_ofs * 4,
	Cast_v0100_matching_01_v0100_matching_01_Reference_sort_move_point_0_0_sort_bt_back_sort												= Layer_v0100_matching_01_v0100_matching_01_Reference_sort | sr_cst_ofs * 5,
	Cast_v0100_matching_01_v0100_matching_01_Reference_sort_move_point_0_0_sort_bt_back_sort_sort_name												= Layer_v0100_matching_01_v0100_matching_01_Reference_sort | sr_cst_ofs * 6,
	Cast_v0100_matching_01_v0100_matching_01_Reference_sort_move_point_0_0_sort_bt_next_sort												= Layer_v0100_matching_01_v0100_matching_01_Reference_sort | sr_cst_ofs * 7,
	Cast_v0100_matching_01_v0100_matching_01_Reference_sort_move_point_0_0_sort_bt_next_sort_sort_name												= Layer_v0100_matching_01_v0100_matching_01_Reference_sort | sr_cst_ofs * 8,
	Cast_v0100_matching_01_v0100_matching_01_Reference_sort_move_point_0_0_sort_yaji												= Layer_v0100_matching_01_v0100_matching_01_Reference_sort | sr_cst_ofs * 9,
	Cast_v0100_matching_01_v0100_matching_01_Reference_sort_move_point_0_0_sort_yaji_back												= Layer_v0100_matching_01_v0100_matching_01_Reference_sort | sr_cst_ofs * 10,
	Cast_v0100_matching_01_v0100_matching_01_Reference_sort_move_point_0_0_sort_yaji_next												= Layer_v0100_matching_01_v0100_matching_01_Reference_sort | sr_cst_ofs * 11,
	Cast_v0100_matching_01_v0100_matching_01_Reference_favorite_move_point_0_0												= Layer_v0100_matching_01_v0100_matching_01_Reference_favorite | sr_cst_ofs * 1,
	Cast_v0100_matching_01_v0100_matching_01_Reference_favorite_move_point_0_0_favorite												= Layer_v0100_matching_01_v0100_matching_01_Reference_favorite | sr_cst_ofs * 2,
	Cast_v0100_matching_01_v0100_matching_01_Reference_favorite_move_point_0_0_favorite_base												= Layer_v0100_matching_01_v0100_matching_01_Reference_favorite | sr_cst_ofs * 3,
	Cast_v0100_matching_01_v0100_matching_01_Reference_favorite_move_point_0_0_favorite_bt												= Layer_v0100_matching_01_v0100_matching_01_Reference_favorite | sr_cst_ofs * 4,
	Cast_v0100_matching_01_v0100_matching_01_Reference_bt_page_next_move_point_0_0												= Layer_v0100_matching_01_v0100_matching_01_Reference_bt_page_next | sr_cst_ofs * 1,
	Cast_v0100_matching_01_v0100_matching_01_Reference_bt_page_next_move_point_0_0_page_next												= Layer_v0100_matching_01_v0100_matching_01_Reference_bt_page_next | sr_cst_ofs * 2,
	Cast_v0100_matching_01_v0100_matching_01_Reference_bt_page_next_move_point_0_0_page_next_bt												= Layer_v0100_matching_01_v0100_matching_01_Reference_bt_page_next | sr_cst_ofs * 3,
	Cast_v0100_matching_01_v0100_matching_01_Reference_bt_page_back_move_point_0_0												= Layer_v0100_matching_01_v0100_matching_01_Reference_bt_page_back | sr_cst_ofs * 1,
	Cast_v0100_matching_01_v0100_matching_01_Reference_bt_page_back_move_point_0_0_page_back												= Layer_v0100_matching_01_v0100_matching_01_Reference_bt_page_back | sr_cst_ofs * 2,
	Cast_v0100_matching_01_v0100_matching_01_Reference_bt_page_back_move_point_0_0_page_back_bt												= Layer_v0100_matching_01_v0100_matching_01_Reference_bt_page_back | sr_cst_ofs * 3,
	Cast_v0100_matching_01_v0100_matching_01_Reference_icon_FOCUS_move_point												= Layer_v0100_matching_01_v0100_matching_01_Reference_icon_FOCUS | sr_cst_ofs * 1,
	Cast_v0100_matching_01_v0100_matching_01_Reference_icon_FOCUS_move_point_icon_f												= Layer_v0100_matching_01_v0100_matching_01_Reference_icon_FOCUS | sr_cst_ofs * 2,
	Cast_v0100_matching_01_v0100_matching_01_Reference_icon_FOCUS_move_point_icon_f_image												= Layer_v0100_matching_01_v0100_matching_01_Reference_icon_FOCUS | sr_cst_ofs * 3,
};

// t@XLXgĒ`
enum v0100_matching_01_Reference_Casts
{
	RefCast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_page_Reference_bt_page_next												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 15,
	RefCast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_page_Reference_bt_page_back												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 16,
	RefCast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_Reference_sort												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 89,
	RefCast_v0100_matching_01_v0100_matching_01_base_move_point_0_0_possession_area_poss_base_Reference_favorite												= Layer_v0100_matching_01_v0100_matching_01_base | sr_cst_ofs * 90,
};

// Aj[VZbg
enum v0100_matching_01_AnimationSets
{
};


// Ro[gNX
class v0100_matching_01Converter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"v0100_matching_01",
	};

	const char* LayerNames[][7] = 
	{
		{
			"base",
			"Reference_sort",
			"Reference_favorite",
			"Reference_bt_page_next",
			"Reference_bt_page_back",
			"Reference_icon_FOCUS",
		},
	};

	const char* AnimeNames[][7][8] = 
	{
		{
			{
				"All_in",
				"All_loop",
				"All_out",
				"favorite_mark_in",
				"favorite_mark_loop",
				"favorite_mark_out",
				"card_in",
			},
			{
				"loop",
				"sort_name",
				"bt_next_active",
				"bt_next_touch",
				"bt_back_active",
				"bt_back_touch",
			},
			{
				"bt_register_active",
				"bt_register_touch",
				"bt_register_grey",
				"bt_release_active",
				"bt_release_touch",
			},
			{
				"active",
				"touch",
				"grey",
			},
			{
				"active",
				"touch",
				"grey",
			},
			{
				"Focus_loop",
			},
		},
	};

	const char* CastNames[][7][125] = 
	{
		{
			{
				"move_point_0_0",
				"possession_area",
				"poss_base",
				"base",
				"base_00",
				"kazari",
				"title",
				"base_01",
				"base_02",
				"clear",
				"page",
				"page_base",
				"page_99_right",
				"page_99_left",
				"Reference_bt_page_next",
				"Reference_bt_page_back",
				"shoji",
				"card_999_right",
				"card_999_left",
				"card_999_left_over",
				"icon_base",
				"01",
				"icon_base_000",
				"icon_base_001",
				"icon_base_002",
				"icon_base_003",
				"icon_base_004",
				"icon_base_005",
				"icon_base_006",
				"icon_base_007",
				"icon_base_008",
				"icon_base_009",
				"02",
				"icon_base_000",
				"icon_base_001",
				"icon_base_002",
				"icon_base_003",
				"icon_base_004",
				"icon_base_005",
				"icon_base_006",
				"icon_base_007",
				"icon_base_008",
				"icon_base_009",
				"03",
				"icon_base_000",
				"icon_base_001",
				"icon_base_002",
				"icon_base_003",
				"icon_base_004",
				"icon_base_005",
				"icon_base_006",
				"icon_base_007",
				"icon_base_008",
				"icon_base_009",
				"icon",
				"01",
				"icon_001",
				"icon_002",
				"icon_003",
				"icon_004",
				"icon_005",
				"icon_006",
				"icon_007",
				"icon_008",
				"icon_009",
				"icon_010",
				"02",
				"icon_001",
				"icon_002",
				"icon_003",
				"icon_004",
				"icon_005",
				"icon_006",
				"icon_007",
				"icon_008",
				"icon_009",
				"icon_010",
				"03",
				"icon_001",
				"icon_002",
				"icon_003",
				"icon_004",
				"icon_005",
				"icon_006",
				"icon_007",
				"icon_008",
				"icon_009",
				"icon_010",
				"Reference_sort",
				"Reference_favorite",
				"pick_up_base",
				"base",
				"base_00",
				"text",
				"monster_name",
				"m_name_12",
				"m_name13_14",
				"m_name15_16",
				"hissatsu",
				"skill_name",
				"mp_99",
				"mp_100",
				"mp_010",
				"mp_001",
				"skill_info",
				"hyphen",
				"lv_99",
				"lv_10",
				"lv_01",
				"otomo_koka",
				"skill_name",
				"skill_info",
				"card",
				"shadow",
				"Refarence_card",
				"favorite_mark",
				"ef",
				"ef_giza",
				"ef_giza1",
				"ef_giza2",
				"info",
				"info_base",
				"info_text",
				"Reference_aco",
			},
			{
				"move_point_0_0",
				"sort",
				"base",
				"now_sort_name",
				"bt_back_sort",
				"sort_name",
				"bt_next_sort",
				"sort_name",
				"yaji",
				"back",
				"next",
			},
			{
				"move_point_0_0",
				"favorite",
				"base",
				"bt",
			},
			{
				"move_point_0_0",
				"page_next",
				"bt",
			},
			{
				"move_point_0_0",
				"page_back",
				"bt",
			},
			{
				"move_point",
				"icon_f",
				"image",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

// CardBox_PageMax   :    page_99_right
// CardBox_PageNow   :    page_99_left
// CardBox_CardMax   :    card_999_right
// CardBox_CardNow   :    card_999_left card_999_left_over
// CardBox_CardNowDisp   :    card_999_left_over
// CardInfo_Name   :    m_name_12 m_name13_14 m_name15_16
// CardInfo_SkillName   :    skill_name
// CardInfo_UseMp   :    mp_100 mp_010 mp_001
// CardInfo_SkillInfo   :    skill_info
// CardInfo_SkillLv   :    lv_10 lv_01
// CardInfo_SupportSkill   :    skill_name
// CardInfo_SupportInfo   :    skill_info
// AcoMsg   :    info_text
