///------------------------------------------------------------------------
/// @file   v0100_matching_02.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_v0100_matching_02_H__ )
#define __SR_v0100_matching_02_H__

namespace surfride { 
namespace header { 

// V[
enum v0100_matching_02_Scenes
{
	Scene_v0100_matching_02_v0100_matching_02												= sr_scn_ofs * 1,
};

// C[
enum v0100_matching_02_Layers
{
	Layer_v0100_matching_02_v0100_matching_02_base												= Scene_v0100_matching_02_v0100_matching_02 | sr_lyr_ofs * 1,
	Layer_v0100_matching_02_v0100_matching_02_Reference_total												= Scene_v0100_matching_02_v0100_matching_02 | sr_lyr_ofs * 2,
	Layer_v0100_matching_02_v0100_matching_02_Reference_bt_ATK												= Scene_v0100_matching_02_v0100_matching_02 | sr_lyr_ofs * 3,
	Layer_v0100_matching_02_v0100_matching_02_Reference_bt_HP												= Scene_v0100_matching_02_v0100_matching_02 | sr_lyr_ofs * 4,
	Layer_v0100_matching_02_v0100_matching_02_Reference_unit												= Scene_v0100_matching_02_v0100_matching_02 | sr_lyr_ofs * 5,
	Layer_v0100_matching_02_v0100_matching_02_Reference_icon_FOCUS												= Scene_v0100_matching_02_v0100_matching_02 | sr_lyr_ofs * 6,
	Layer_v0100_matching_02_v0100_matching_02_Reference_leader_FOCUS												= Scene_v0100_matching_02_v0100_matching_02 | sr_lyr_ofs * 7,
};

// Aj[V
enum v0100_matching_02_Animations
{
	Animation_v0100_matching_02_v0100_matching_02_base_All_in												= Layer_v0100_matching_02_v0100_matching_02_base | sr_anm_ofs * 1,
	Animation_v0100_matching_02_v0100_matching_02_base_All_loop												= Layer_v0100_matching_02_v0100_matching_02_base | sr_anm_ofs * 2,
	Animation_v0100_matching_02_v0100_matching_02_base_All_out												= Layer_v0100_matching_02_v0100_matching_02_base | sr_anm_ofs * 3,
	Animation_v0100_matching_02_v0100_matching_02_Reference_total_red_meter												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_anm_ofs * 1,
	Animation_v0100_matching_02_v0100_matching_02_Reference_total_bule_meter												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_anm_ofs * 2,
	Animation_v0100_matching_02_v0100_matching_02_Reference_total_green_meter												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_anm_ofs * 3,
	Animation_v0100_matching_02_v0100_matching_02_Reference_total_yellow_meter												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_anm_ofs * 4,
	Animation_v0100_matching_02_v0100_matching_02_Reference_total_purple_meter												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_anm_ofs * 5,
	Animation_v0100_matching_02_v0100_matching_02_Reference_bt_ATK_bt_ATK_active												= Layer_v0100_matching_02_v0100_matching_02_Reference_bt_ATK | sr_anm_ofs * 1,
	Animation_v0100_matching_02_v0100_matching_02_Reference_bt_ATK_bt_ATK_touch												= Layer_v0100_matching_02_v0100_matching_02_Reference_bt_ATK | sr_anm_ofs * 2,
	Animation_v0100_matching_02_v0100_matching_02_Reference_bt_ATK_bt_ATK_grey												= Layer_v0100_matching_02_v0100_matching_02_Reference_bt_ATK | sr_anm_ofs * 3,
	Animation_v0100_matching_02_v0100_matching_02_Reference_bt_HP_bt_HP_active												= Layer_v0100_matching_02_v0100_matching_02_Reference_bt_HP | sr_anm_ofs * 1,
	Animation_v0100_matching_02_v0100_matching_02_Reference_bt_HP_bt_HP_touch												= Layer_v0100_matching_02_v0100_matching_02_Reference_bt_HP | sr_anm_ofs * 2,
	Animation_v0100_matching_02_v0100_matching_02_Reference_bt_HP_bt_HP_grey												= Layer_v0100_matching_02_v0100_matching_02_Reference_bt_HP | sr_anm_ofs * 3,
	Animation_v0100_matching_02_v0100_matching_02_Reference_unit_loop_no_leader												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_anm_ofs * 1,
	Animation_v0100_matching_02_v0100_matching_02_Reference_unit_otomo_00_in												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_anm_ofs * 2,
	Animation_v0100_matching_02_v0100_matching_02_Reference_unit_otomo_00_loop												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_anm_ofs * 3,
	Animation_v0100_matching_02_v0100_matching_02_Reference_unit_otomo_00_out												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_anm_ofs * 4,
	Animation_v0100_matching_02_v0100_matching_02_Reference_unit_otomo_01_in												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_anm_ofs * 5,
	Animation_v0100_matching_02_v0100_matching_02_Reference_unit_otomo_01_loop_ef												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_anm_ofs * 6,
	Animation_v0100_matching_02_v0100_matching_02_Reference_unit_otomo_01_out												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_anm_ofs * 7,
	Animation_v0100_matching_02_v0100_matching_02_Reference_unit_otomo_02_in												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_anm_ofs * 8,
	Animation_v0100_matching_02_v0100_matching_02_Reference_unit_otomo_02_loop_ef												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_anm_ofs * 9,
	Animation_v0100_matching_02_v0100_matching_02_Reference_unit_otomo_02_out												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_anm_ofs * 10,
	Animation_v0100_matching_02_v0100_matching_02_Reference_unit_otomo_03_in												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_anm_ofs * 11,
	Animation_v0100_matching_02_v0100_matching_02_Reference_unit_otomo_03_loop_ef												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_anm_ofs * 12,
	Animation_v0100_matching_02_v0100_matching_02_Reference_unit_otomo_03_out												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_anm_ofs * 13,
	Animation_v0100_matching_02_v0100_matching_02_Reference_icon_FOCUS_Focus_loop												= Layer_v0100_matching_02_v0100_matching_02_Reference_icon_FOCUS | sr_anm_ofs * 1,
	Animation_v0100_matching_02_v0100_matching_02_Reference_leader_FOCUS_Focus_loop												= Layer_v0100_matching_02_v0100_matching_02_Reference_leader_FOCUS | sr_anm_ofs * 1,
};

// LXg
enum v0100_matching_02_Casts
{
	Cast_v0100_matching_02_v0100_matching_02_base_move_point_0_0												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 1,
	Cast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 2,
	Cast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_title												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 3,
	Cast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_title_genzai_party												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 4,
	Cast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_base												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 5,
	Cast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_unit												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 6,
	Cast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_unit_Reference_unit_00												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 7,
	Cast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_unit_Reference_unit_01												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 8,
	Cast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_unit_Reference_unit_02												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 9,
	Cast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_unit_Reference_unit_03												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 10,
	Cast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_Reference_total												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 11,
	Cast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_omakase												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 12,
	Cast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_omakase_base												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 13,
	Cast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_omakase_Reference_bt_ATK												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 14,
	Cast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_omakase_Reference_bt_HP												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 15,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 1,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 2,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_base												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 3,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_graph												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 4,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_graph_red												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 5,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_graph_red_red_puyo												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 6,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_graph_bule												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 7,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_graph_bule_bule_puyo												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 8,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_graph_green												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 9,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_graph_green_green_puyo												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 10,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_graph_yellow												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 11,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_graph_yellow_yellow_puyo												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 12,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_graph_purple												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 13,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_graph_purple_purple_puyo												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 14,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_text												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 15,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_text_atk												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 16,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_text_atk_1000												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 17,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_text_atk_0100												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 18,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_text_atk_0010												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 19,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_text_atk_0001												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 20,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_text_hp												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 21,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_text_hp_1000												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 22,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_text_hp_0100												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 23,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_text_hp_0010												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 24,
	Cast_v0100_matching_02_v0100_matching_02_Reference_total_move_point_0_0_total_text_hp_0001												= Layer_v0100_matching_02_v0100_matching_02_Reference_total | sr_cst_ofs * 25,
	Cast_v0100_matching_02_v0100_matching_02_Reference_bt_ATK_move_point_0_0												= Layer_v0100_matching_02_v0100_matching_02_Reference_bt_ATK | sr_cst_ofs * 1,
	Cast_v0100_matching_02_v0100_matching_02_Reference_bt_ATK_move_point_0_0_ATK												= Layer_v0100_matching_02_v0100_matching_02_Reference_bt_ATK | sr_cst_ofs * 2,
	Cast_v0100_matching_02_v0100_matching_02_Reference_bt_ATK_move_point_0_0_ATK_bt												= Layer_v0100_matching_02_v0100_matching_02_Reference_bt_ATK | sr_cst_ofs * 3,
	Cast_v0100_matching_02_v0100_matching_02_Reference_bt_HP_move_point_0_0												= Layer_v0100_matching_02_v0100_matching_02_Reference_bt_HP | sr_cst_ofs * 1,
	Cast_v0100_matching_02_v0100_matching_02_Reference_bt_HP_move_point_0_0_HP												= Layer_v0100_matching_02_v0100_matching_02_Reference_bt_HP | sr_cst_ofs * 2,
	Cast_v0100_matching_02_v0100_matching_02_Reference_bt_HP_move_point_0_0_HP_bt												= Layer_v0100_matching_02_v0100_matching_02_Reference_bt_HP | sr_cst_ofs * 3,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 1,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 2,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_all_base												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 3,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_all_base_leader_base												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 4,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_all_base_leader_base_Reference_leader												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 5,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_otomo_all_base												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 6,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_otomo_all_base_otomo_base												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 7,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_otomo_all_base_otomo_base_otomo_base_01												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 8,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_otomo_all_base_otomo_base_otomo_base_02												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 9,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_otomo_all_base_otomo_base_otomo_base_03												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 10,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_otomo_all_base_otomo_ef												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 11,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_otomo_all_base_otomo_ef_effect_00												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 12,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_otomo_all_base_otomo_ef_effect_01												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 13,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_otomo_all_base_otomo_ef_effect_02												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 14,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_otomo_all_base_otomo_icon												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 15,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_otomo_all_base_otomo_icon_otomo_icon_01												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 16,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_otomo_all_base_otomo_icon_otomo_icon_02												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 17,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_otomo_all_base_otomo_icon_otomo_icon_03												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 18,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_info_ef												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 19,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_info_ef_frame_ef												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 20,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_info_ef_frame_ef_ptn												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 21,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_info_ef_text												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 22,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_drop_ef												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 23,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_drop_ef_waku_add_effect												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 24,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_drop_ef_kemuri_move												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 25,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_drop_ef_kemuri_move_kemuri												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 26,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_drop_ef_kemuri_move_kemuri1												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 27,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_drop_ef_kemuri_move_kemuri2												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 28,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_drop_ef_kemuri_move_kemuri3												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 29,
	Cast_v0100_matching_02_v0100_matching_02_Reference_unit_move_point_party_line_drop_ef_kemuri_move_kemuri4												= Layer_v0100_matching_02_v0100_matching_02_Reference_unit | sr_cst_ofs * 30,
	Cast_v0100_matching_02_v0100_matching_02_Reference_icon_FOCUS_move_point												= Layer_v0100_matching_02_v0100_matching_02_Reference_icon_FOCUS | sr_cst_ofs * 1,
	Cast_v0100_matching_02_v0100_matching_02_Reference_icon_FOCUS_move_point_icon_f												= Layer_v0100_matching_02_v0100_matching_02_Reference_icon_FOCUS | sr_cst_ofs * 2,
	Cast_v0100_matching_02_v0100_matching_02_Reference_icon_FOCUS_move_point_icon_f_image												= Layer_v0100_matching_02_v0100_matching_02_Reference_icon_FOCUS | sr_cst_ofs * 3,
	Cast_v0100_matching_02_v0100_matching_02_Reference_leader_FOCUS_move_point												= Layer_v0100_matching_02_v0100_matching_02_Reference_leader_FOCUS | sr_cst_ofs * 1,
	Cast_v0100_matching_02_v0100_matching_02_Reference_leader_FOCUS_move_point_icon_f												= Layer_v0100_matching_02_v0100_matching_02_Reference_leader_FOCUS | sr_cst_ofs * 2,
	Cast_v0100_matching_02_v0100_matching_02_Reference_leader_FOCUS_move_point_icon_f_image												= Layer_v0100_matching_02_v0100_matching_02_Reference_leader_FOCUS | sr_cst_ofs * 3,
};

// t@XLXgĒ`
enum v0100_matching_02_Reference_Casts
{
	RefCast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_unit_Reference_unit_00												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 7,
	RefCast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_unit_Reference_unit_01												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 8,
	RefCast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_unit_Reference_unit_02												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 9,
	RefCast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_unit_Reference_unit_03												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 10,
	RefCast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_Reference_total												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 11,
	RefCast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_omakase_Reference_bt_ATK												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 14,
	RefCast_v0100_matching_02_v0100_matching_02_base_move_point_0_0_party_omakase_Reference_bt_HP												= Layer_v0100_matching_02_v0100_matching_02_base | sr_cst_ofs * 15,
};

// Aj[VZbg
enum v0100_matching_02_AnimationSets
{
};


// Ro[gNX
class v0100_matching_02Converter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"v0100_matching_02",
	};

	const char* LayerNames[][8] = 
	{
		{
			"base",
			"Reference_total",
			"Reference_bt_ATK",
			"Reference_bt_HP",
			"Reference_unit",
			"Reference_icon_FOCUS",
			"Reference_leader_FOCUS",
		},
	};

	const char* AnimeNames[][8][14] = 
	{
		{
			{
				"All_in",
				"All_loop",
				"All_out",
			},
			{
				"red_meter",
				"bule_meter",
				"green_meter",
				"yellow_meter",
				"purple_meter",
			},
			{
				"bt_ATK_active",
				"bt_ATK_touch",
				"bt_ATK_grey",
			},
			{
				"bt_HP_active",
				"bt_HP_touch",
				"bt_HP_grey",
			},
			{
				"loop_no_leader",
				"otomo_00_in",
				"otomo_00_loop",
				"otomo_00_out",
				"otomo_01_in",
				"otomo_01_loop_ef",
				"otomo_01_out",
				"otomo_02_in",
				"otomo_02_loop_ef",
				"otomo_02_out",
				"otomo_03_in",
				"otomo_03_loop_ef",
				"otomo_03_out",
			},
			{
				"Focus_loop",
			},
			{
				"Focus_loop",
			},
		},
	};

	const char* CastNames[][8][31] = 
	{
		{
			{
				"move_point_0_0",
				"party",
				"title",
				"genzai_party",
				"base",
				"unit",
				"Reference_unit_00",
				"Reference_unit_01",
				"Reference_unit_02",
				"Reference_unit_03",
				"Reference_total",
				"omakase",
				"base",
				"Reference_bt_ATK",
				"Reference_bt_HP",
			},
			{
				"move_point_0_0",
				"total",
				"base",
				"graph",
				"red",
				"red_puyo",
				"bule",
				"bule_puyo",
				"green",
				"green_puyo",
				"yellow",
				"yellow_puyo",
				"purple",
				"purple_puyo",
				"text",
				"atk",
				"1000",
				"0100",
				"0010",
				"0001",
				"hp",
				"1000",
				"0100",
				"0010",
				"0001",
			},
			{
				"move_point_0_0",
				"ATK",
				"bt",
			},
			{
				"move_point_0_0",
				"HP",
				"bt",
			},
			{
				"move_point",
				"party_line",
				"all_base",
				"leader_base",
				"Reference_leader",
				"otomo_all_base",
				"otomo_base",
				"otomo_base_01",
				"otomo_base_02",
				"otomo_base_03",
				"otomo_ef",
				"effect_00",
				"effect_01",
				"effect_02",
				"otomo_icon",
				"otomo_icon_01",
				"otomo_icon_02",
				"otomo_icon_03",
				"info_ef",
				"frame_ef",
				"ptn",
				"text",
				"drop_ef",
				"waku_add_effect",
				"kemuri_move",
				"kemuri",
				"kemuri1",
				"kemuri2",
				"kemuri3",
				"kemuri4",
			},
			{
				"move_point",
				"icon_f",
				"image",
			},
			{
				"move_point",
				"icon_f",
				"image",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

// PartyBox_Atk   :    1000 0100 0010 0001
// PartyBox_Hp   :    1000 0100 0010 0001
// PartyBox_MeterRed   :    red_meter
// PartyBox_MeterBlue   :    bule_meter
// PartyBox_MeterGreen   :    green_meter
// PartyBox_MeterYellow   :    yellow_meter
// PartyBox_MeterPurple   :    purple_meter
