///------------------------------------------------------------------------
/// @file   v0100_transition_00.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_v0100_transition_00_H__ )
#define __SR_v0100_transition_00_H__

namespace surfride { 
namespace header { 

// V[
enum v0100_transition_00_Scenes
{
	Scene_v0100_transition_00_v0100_transition_00												= sr_scn_ofs * 1,
};

// C[
enum v0100_transition_00_Layers
{
	Layer_v0100_transition_00_v0100_transition_00_Transition_typeA												= Scene_v0100_transition_00_v0100_transition_00 | sr_lyr_ofs * 1,
	Layer_v0100_transition_00_v0100_transition_00_Transition_typeB												= Scene_v0100_transition_00_v0100_transition_00 | sr_lyr_ofs * 2,
	Layer_v0100_transition_00_v0100_transition_00_Transition_typeC												= Scene_v0100_transition_00_v0100_transition_00 | sr_lyr_ofs * 3,
	Layer_v0100_transition_00_v0100_transition_00_Transition_typeD												= Scene_v0100_transition_00_v0100_transition_00 | sr_lyr_ofs * 4,
	Layer_v0100_transition_00_v0100_transition_00_Transition_typeE												= Scene_v0100_transition_00_v0100_transition_00 | sr_lyr_ofs * 5,
	Layer_v0100_transition_00_v0100_transition_00_Transition_White												= Scene_v0100_transition_00_v0100_transition_00 | sr_lyr_ofs * 6,
	Layer_v0100_transition_00_v0100_transition_00_Reference_dot_loop												= Scene_v0100_transition_00_v0100_transition_00 | sr_lyr_ofs * 7,
	Layer_v0100_transition_00_v0100_transition_00_Reference_kazari												= Scene_v0100_transition_00_v0100_transition_00 | sr_lyr_ofs * 8,
};

// Aj[V
enum v0100_transition_00_Animations
{
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeA_typeA_in_out												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_anm_ofs * 1,
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeA_typeA_in												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_anm_ofs * 2,
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeA_typeA_loop												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_anm_ofs * 3,
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeA_typeA_out												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_anm_ofs * 4,
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeB_typeB_in_out												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_anm_ofs * 1,
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeB_typeB_in												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_anm_ofs * 2,
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeB_typeB_loop												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_anm_ofs * 3,
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeB_typeB_out												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_anm_ofs * 4,
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeC_typeC_in_out												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_anm_ofs * 1,
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeC_typeC_in												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_anm_ofs * 2,
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeC_typeC_loop												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_anm_ofs * 3,
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeC_typeC_out												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_anm_ofs * 4,
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeD_typeD_in_out												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_anm_ofs * 1,
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeD_typeD_in												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_anm_ofs * 2,
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeD_typeD_loop												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_anm_ofs * 3,
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeD_typeD_out												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_anm_ofs * 4,
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeE_typeE_in_out												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_anm_ofs * 1,
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeE_typeE_in												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_anm_ofs * 2,
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeE_typeE_loop												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_anm_ofs * 3,
	Animation_v0100_transition_00_v0100_transition_00_Transition_typeE_typeE_out												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_anm_ofs * 4,
	Animation_v0100_transition_00_v0100_transition_00_Transition_White_white_in												= Layer_v0100_transition_00_v0100_transition_00_Transition_White | sr_anm_ofs * 1,
	Animation_v0100_transition_00_v0100_transition_00_Transition_White_white_out												= Layer_v0100_transition_00_v0100_transition_00_Transition_White | sr_anm_ofs * 2,
	Animation_v0100_transition_00_v0100_transition_00_Reference_dot_loop_loop												= Layer_v0100_transition_00_v0100_transition_00_Reference_dot_loop | sr_anm_ofs * 1,
	Animation_v0100_transition_00_v0100_transition_00_Reference_kazari_loop												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_anm_ofs * 1,
};

// LXg
enum v0100_transition_00_Casts
{
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 1,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_A												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 2,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_A_white												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 3,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_A_puyo												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 4,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_A_puyo_puyo_shadow												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 5,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_A_puyo_puyo_shadow_right												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 6,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_A_puyo_puyo_shadow_left												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 7,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_A_puyo_puyo_shadow_under												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 8,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_A_puyo_puyo_shadow_top												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 9,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_A_puyo_puyo												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 10,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_A_puyo_puyo_right												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 11,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_A_puyo_puyo_left												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 12,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_A_puyo_puyo_under												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 13,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_A_puyo_puyo_top												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 14,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_A_puyo_grade												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 15,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_dot_loop												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 16,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_kazari												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 17,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_kazari_Cast_0670												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 18,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_logo												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 19,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 1,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_A												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 2,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_A_white												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 3,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_A_puyo												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 4,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_A_puyo_puyo_shadow												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 5,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_A_puyo_puyo_shadow_right												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 6,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_A_puyo_puyo_shadow_left												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 7,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_A_puyo_puyo_shadow_under												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 8,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_A_puyo_puyo_shadow_top												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 9,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_A_puyo_puyo												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 10,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_A_puyo_puyo_right												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 11,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_A_puyo_puyo_left												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 12,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_A_puyo_puyo_under												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 13,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_A_puyo_puyo_top												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 14,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_A_puyo_grade												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 15,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_dot_loop												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 16,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_kazari												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 17,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_kazari_Cast_0670												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 18,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_logo												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 19,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 1,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_A												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 2,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_A_white												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 3,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_A_puyo												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 4,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_A_puyo_puyo_shadow												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 5,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_A_puyo_puyo_shadow_right												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 6,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_A_puyo_puyo_shadow_left												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 7,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_A_puyo_puyo_shadow_under												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 8,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_A_puyo_puyo_shadow_top												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 9,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_A_puyo_puyo												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 10,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_A_puyo_puyo_right												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 11,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_A_puyo_puyo_left												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 12,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_A_puyo_puyo_under												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 13,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_A_puyo_puyo_top												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 14,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_A_puyo_grade												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 15,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_dot_loop												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 16,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_kazari												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 17,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_kazari_Cast_0670												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 18,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_logo												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 19,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 1,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_A												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 2,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_A_white												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 3,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_A_puyo												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 4,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_A_puyo_puyo_shadow												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 5,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_A_puyo_puyo_shadow_right												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 6,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_A_puyo_puyo_shadow_left												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 7,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_A_puyo_puyo_shadow_under												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 8,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_A_puyo_puyo_shadow_top												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 9,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_A_puyo_puyo												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 10,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_A_puyo_puyo_right												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 11,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_A_puyo_puyo_left												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 12,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_A_puyo_puyo_under												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 13,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_A_puyo_puyo_top												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 14,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_A_puyo_grade												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 15,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_dot_loop												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 16,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_kazari												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 17,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_kazari_Cast_0670												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 18,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_logo												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 19,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 1,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_A												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 2,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_A_white												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 3,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_A_puyo												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 4,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_A_puyo_puyo_shadow												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 5,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_A_puyo_puyo_shadow_right												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 6,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_A_puyo_puyo_shadow_left												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 7,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_A_puyo_puyo_shadow_under												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 8,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_A_puyo_puyo_shadow_top												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 9,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_A_puyo_puyo												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 10,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_A_puyo_puyo_right												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 11,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_A_puyo_puyo_left												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 12,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_A_puyo_puyo_under												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 13,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_A_puyo_puyo_top												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 14,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_A_puyo_grade												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 15,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_dot_loop												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 16,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_kazari												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 17,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_kazari_Cast_0670												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 18,
	Cast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_logo												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 19,
	Cast_v0100_transition_00_v0100_transition_00_Transition_White_move_point												= Layer_v0100_transition_00_v0100_transition_00_Transition_White | sr_cst_ofs * 1,
	Cast_v0100_transition_00_v0100_transition_00_Transition_White_move_point_white												= Layer_v0100_transition_00_v0100_transition_00_Transition_White | sr_cst_ofs * 2,
	Cast_v0100_transition_00_v0100_transition_00_Reference_dot_loop_move_point												= Layer_v0100_transition_00_v0100_transition_00_Reference_dot_loop | sr_cst_ofs * 1,
	Cast_v0100_transition_00_v0100_transition_00_Reference_dot_loop_move_point_Dot												= Layer_v0100_transition_00_v0100_transition_00_Reference_dot_loop | sr_cst_ofs * 2,
	Cast_v0100_transition_00_v0100_transition_00_Reference_dot_loop_move_point_Dot_ptn												= Layer_v0100_transition_00_v0100_transition_00_Reference_dot_loop | sr_cst_ofs * 3,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 1,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_Cast_0236												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 2,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_Cast_0236_kazari_01												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 3,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_Cast_0236_kazari_01_Cast_0208												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 4,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_Cast_0236_kazari_01_Cast_0215												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 5,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_Cast_0236_kazari_01_Cast_0209												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 6,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_Cast_0236_kazari_01_Cast_0210												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 7,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_Cast_0236_kazari_01_Cast_0214												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 8,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_Cast_0236_kazari_03												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 9,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_Cast_0236_kazari_03_Cast_0208												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 10,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_Cast_0236_kazari_03_Cast_0215												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 11,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_Cast_0236_kazari_03_Cast_0209												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 12,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_Cast_0236_kazari_03_Cast_0210												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 13,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_Cast_0236_kazari_03_Cast_0214												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 14,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_Cast_0236_kazari_04												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 15,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_Cast_0236_kazari_04_Cast_0208												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 16,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_Cast_0236_kazari_04_Cast_0215												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 17,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_Cast_0236_kazari_04_Cast_0209												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 18,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_Cast_0236_kazari_04_Cast_0210												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 19,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_Cast_0236_kazari_04_Cast_0214												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 20,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_kazari_02												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 21,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_kazari_02_Cast_0209												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 22,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_kazari_02_Cast_0214												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 23,
	Cast_v0100_transition_00_v0100_transition_00_Reference_kazari_move_point_kazari_02_Cast_0223												= Layer_v0100_transition_00_v0100_transition_00_Reference_kazari | sr_cst_ofs * 24,
};

// t@XLXgĒ`
enum v0100_transition_00_Reference_Casts
{
	RefCast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_dot_loop												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 16,
	RefCast_v0100_transition_00_v0100_transition_00_Transition_typeA_move_point_kazari_Cast_0670												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeA | sr_cst_ofs * 18,
	RefCast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_dot_loop												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 16,
	RefCast_v0100_transition_00_v0100_transition_00_Transition_typeB_move_point_kazari_Cast_0670												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeB | sr_cst_ofs * 18,
	RefCast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_dot_loop												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 16,
	RefCast_v0100_transition_00_v0100_transition_00_Transition_typeC_move_point_kazari_Cast_0670												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeC | sr_cst_ofs * 18,
	RefCast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_dot_loop												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 16,
	RefCast_v0100_transition_00_v0100_transition_00_Transition_typeD_move_point_kazari_Cast_0670												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeD | sr_cst_ofs * 18,
	RefCast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_dot_loop												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 16,
	RefCast_v0100_transition_00_v0100_transition_00_Transition_typeE_move_point_kazari_Cast_0670												= Layer_v0100_transition_00_v0100_transition_00_Transition_typeE | sr_cst_ofs * 18,
};

// Aj[VZbg
enum v0100_transition_00_AnimationSets
{
};


// Ro[gNX
class v0100_transition_00Converter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"v0100_transition_00",
	};

	const char* LayerNames[][9] = 
	{
		{
			"Transition_typeA",
			"Transition_typeB",
			"Transition_typeC",
			"Transition_typeD",
			"Transition_typeE",
			"Transition_White",
			"Reference_dot_loop",
			"Reference_kazari",
		},
	};

	const char* AnimeNames[][9][5] = 
	{
		{
			{
				"typeA_in_out",
				"typeA_in",
				"typeA_loop",
				"typeA_out",
			},
			{
				"typeB_in_out",
				"typeB_in",
				"typeB_loop",
				"typeB_out",
			},
			{
				"typeC_in_out",
				"typeC_in",
				"typeC_loop",
				"typeC_out",
			},
			{
				"typeD_in_out",
				"typeD_in",
				"typeD_loop",
				"typeD_out",
			},
			{
				"typeE_in_out",
				"typeE_in",
				"typeE_loop",
				"typeE_out",
			},
			{
				"white_in",
				"white_out",
			},
			{
				"loop",
			},
			{
				"loop",
			},
		},
	};

	const char* CastNames[][9][25] = 
	{
		{
			{
				"move_point",
				"A",
				"white",
				"puyo",
				"puyo_shadow",
				"right",
				"left",
				"under",
				"top",
				"puyo",
				"right",
				"left",
				"under",
				"top",
				"grade",
				"dot_loop",
				"kazari",
				"Cast_0670",
				"logo",
			},
			{
				"move_point",
				"A",
				"white",
				"puyo",
				"puyo_shadow",
				"right",
				"left",
				"under",
				"top",
				"puyo",
				"right",
				"left",
				"under",
				"top",
				"grade",
				"dot_loop",
				"kazari",
				"Cast_0670",
				"logo",
			},
			{
				"move_point",
				"A",
				"white",
				"puyo",
				"puyo_shadow",
				"right",
				"left",
				"under",
				"top",
				"puyo",
				"right",
				"left",
				"under",
				"top",
				"grade",
				"dot_loop",
				"kazari",
				"Cast_0670",
				"logo",
			},
			{
				"move_point",
				"A",
				"white",
				"puyo",
				"puyo_shadow",
				"right",
				"left",
				"under",
				"top",
				"puyo",
				"right",
				"left",
				"under",
				"top",
				"grade",
				"dot_loop",
				"kazari",
				"Cast_0670",
				"logo",
			},
			{
				"move_point",
				"A",
				"white",
				"puyo",
				"puyo_shadow",
				"right",
				"left",
				"under",
				"top",
				"puyo",
				"right",
				"left",
				"under",
				"top",
				"grade",
				"dot_loop",
				"kazari",
				"Cast_0670",
				"logo",
			},
			{
				"move_point",
				"white",
			},
			{
				"move_point",
				"Dot",
				"ptn",
			},
			{
				"move_point",
				"Cast_0236",
				"kazari_01",
				"Cast_0208",
				"Cast_0215",
				"Cast_0209",
				"Cast_0210",
				"Cast_0214",
				"kazari_03",
				"Cast_0208",
				"Cast_0215",
				"Cast_0209",
				"Cast_0210",
				"Cast_0214",
				"kazari_04",
				"Cast_0208",
				"Cast_0215",
				"Cast_0209",
				"Cast_0210",
				"Cast_0214",
				"kazari_02",
				"Cast_0209",
				"Cast_0214",
				"Cast_0223",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

