/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

abstract class AgesBase
extends MIDlet
implements Runnable {
    private static Display display;
    public static int game_mode;
    public static MIDlet midlet;
    public static Puyo2Canvas canvas;
    protected static Thread thread;
    public static Class _class;
    private static Random random;
    static int keyData;
    static int keyPush;
    static int keyRepeat;
    static int keyCounter;
    static int keyLast;
    public static int offsetX;
    public static int offsetY;
    public static boolean stopflag;
    public static boolean once;
    public Image logo;
    public static Graphics gc;
    public static int commonCounter;
    private static InputStream _is;
    private static boolean load_flag;
    public static boolean draw_flag;
    public static boolean sound_flag;
    private boolean paint_flag = true;
    static final int KEY_REPEAT1 = 8;
    static final int KEY_REPEAT2 = 2;
    public static final Player[] sound;
    public static boolean key_pause;

    public AgesBase() {
        midlet = this;
        _class = this.getClass();
        canvas = new Puyo2Canvas();
        display = Display.getDisplay((MIDlet)this);
        try {
            this.logo = Image.createImage((String)"/segalogo.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        random = new Random(System.currentTimeMillis());
    }

    static void playBgm(int n) {
        try {
            AgesBase.stopBgm();
            if (sound_flag && sound[n].getState() != 400) {
                sound[n].realize();
                sound[n].setMediaTime(0L);
                sound[n].setLoopCount(-1);
                sound[n].prefetch();
                sound[n].start();
            }
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    static void stopBgm() {
        try {
            for (int i = 0; i < 2; ++i) {
                if (sound[i] == null || sound[i].getState() != 400) continue;
                sound[i].stop();
            }
        }
        catch (MediaException mediaException) {
            System.out.println("Error in stopping media");
        }
    }

    static void pauseBgm() {
        try {
            sound[1].stop();
        }
        catch (MediaException mediaException) {
            System.out.println("Error in mediaexception");
        }
    }

    static void resumeBgm() {
        AgesBase.stopBgm();
        try {
            if (sound_flag && sound[1].getState() != 400) {
                sound[1].realize();
                sound[1].setMediaTime(0L);
                sound[1].setLoopCount(-1);
                sound[1].prefetch();
                sound[1].start();
            }
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    abstract void game_synch(boolean var1);

    public void startApp() {
        if (thread == null) {
            display.setCurrent((Displayable)canvas);
            thread = new Thread(this);
            thread.start();
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
        AgesBase.stopBgm();
    }

    public void run() {
        while (thread != null) {
            try {
                long l = System.currentTimeMillis();
                canvas.repaint();
                long l2 = System.currentTimeMillis() - l;
                if (l2 >= 30L) continue;
                Thread.sleep(30L - l2);
            }
            catch (Exception exception) {}
        }
    }

    public static int rnd(int n) {
        return (random.nextInt() & Integer.MAX_VALUE) % n;
    }

    public static void drawString(int n, String string, int n2, int n3, int n4) {
        gc.setColor(0x404040);
        gc.drawString(string, offsetX + n2 - 1, offsetY + n3, n4);
        gc.drawString(string, n2 + 1 + offsetX, offsetY + n3, n4);
        gc.drawString(string, n2 + offsetX, offsetY + n3 - 1, n4);
        gc.drawString(string, n2 + offsetX, offsetY + n3 + 1, n4);
        gc.setColor(n);
        gc.drawString(string, n2 + offsetX, offsetY + n3, n4);
    }

    public static void drawString(int n, String string, int n2, int n3) {
        AgesBase.drawString(n, string, n2, n3, 20);
    }

    public static void drawCenter(int n, String string, int n2) {
        AgesBase.drawString(n, string, 75, n2, 17);
    }

    public static void file_open(int n) {
        load_flag = true;
        while (true) {
            try {
                if (_is != null) {
                    _is.close();
                }
                _is = _class.getResourceAsStream("f" + n);
                return;
            }
            catch (Exception exception) {
                Thread.yield();
                continue;
            }
            break;
        }
    }

    public static boolean file_close() {
        if (_is == null) {
            return true;
        }
        try {
            _is.close();
            _is = null;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static byte[] load_resource() {
        if (!load_flag) {
            return null;
        }
        Thread.yield();
        try {
            int n = _is.read();
            byte[] byArray = new byte[n += _is.read() << 8];
            _is.read(byArray);
            return byArray;
        }
        catch (Exception exception) {
            load_flag = false;
            return null;
        }
    }

    public static boolean skip_resource(int n) {
        while (n > 0) {
            try {
                int n2 = _is.read();
                _is.skip(n2 += _is.read() << 8);
                --n;
            }
            catch (Exception exception) {
                load_flag = false;
                return false;
            }
        }
        return true;
    }

    public static Image load_image() {
        try {
            byte[] byArray = AgesBase.load_resource();
            return Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        }
        catch (Exception exception) {
            load_flag = false;
            return null;
        }
    }

    public static byte[] readSram(String string) {
        while (true) {
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
                byte[] byArray = recordStore.getRecord(1);
                recordStore.closeRecordStore();
                return byArray;
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                return null;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public static void writeSram(String string, byte[] byArray, boolean bl) {
        while (true) {
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
                if (bl) {
                    recordStore.addRecord(byArray, 0, byArray.length);
                } else {
                    recordStore.setRecord(1, byArray, 0, byArray.length);
                }
                recordStore.closeRecordStore();
                return;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public static final void sleep(long l) {
        System.gc();
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sleep() {
        try {
            System.gc();
            Thread.sleep(30L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void drawArrow(int n, int n2) {
        int n3 = n2 + 7;
        gc.setColor(0xFFFFFF);
        for (int i = 3; i >= 0; --i) {
            gc.drawLine(n, n2, n + 7 - i * 2, n2);
            gc.drawLine(n, n3, n + 7 - i * 2, n3);
            ++n2;
            --n3;
        }
    }

    public static final int getInteger(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
    }

    public static final void setInteger(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 24);
        byArray[n + 1] = (byte)(n2 >> 16);
        byArray[n + 2] = (byte)(n2 >> 8);
        byArray[n + 3] = (byte)n2;
    }

    static {
        thread = null;
        random = null;
        keyData = 0;
        keyPush = 0;
        keyRepeat = 0;
        keyCounter = 0;
        keyLast = 0;
        gc = null;
        commonCounter = 0;
        _is = null;
        draw_flag = true;
        sound = new Player[2];
        key_pause = false;
    }

    public class Puyo2Canvas
    extends FullCanvas {
        private int key_buf = 0;
        private int key_pressed = 0;

        Puyo2Canvas() {
            offsetX = (this.getWidth() - 150) / 2;
            offsetY = (this.getHeight() - 170) / 2;
        }

        public int getKeyState() {
            int n = this.key_buf | this.key_pressed;
            this.key_pressed = 0;
            return n;
        }

        public synchronized void keyPressed(int n) {
            if (n == 48) {
                this.key_buf = this.bitOn(this.key_buf, 0);
            } else if (n == 49) {
                this.key_buf = this.bitOn(this.key_buf, 1);
            } else if (n == 50) {
                this.key_buf = this.bitOn(this.key_buf, 2);
            } else if (n == 52) {
                this.key_buf = this.bitOn(this.key_buf, 4);
            } else if (n == 53) {
                this.key_buf = this.bitOn(this.key_buf, 5);
            } else if (n == 54) {
                this.key_buf = this.bitOn(this.key_buf, 6);
            } else if (n == 56) {
                this.key_buf = this.bitOn(this.key_buf, 8);
            } else if (n == 35) {
                this.key_buf = this.bitOn(this.key_buf, 11);
            } else if (n == 42) {
                this.key_buf = this.bitOn(this.key_buf, 10);
            } else if (n == -1) {
                this.key_buf = this.bitOn(this.key_buf, 12);
            } else if (n == -2) {
                this.key_buf = this.bitOn(this.key_buf, 15);
            } else if (n == -3) {
                this.key_buf = this.bitOn(this.key_buf, 13);
            } else if (n == -4) {
                this.key_buf = this.bitOn(this.key_buf, 14);
            } else if (n == -5) {
                this.key_buf = this.bitOn(this.key_buf, 16);
            } else if (n == -6) {
                this.key_buf = this.bitOn(this.key_buf, 17);
            } else if (n == -7) {
                this.key_buf = this.bitOn(this.key_buf, 18);
            }
        }

        public synchronized void keyReleased(int n) {
            if (n == 48) {
                this.key_buf = this.bitOff(this.key_buf, 0);
            } else if (n == 49) {
                this.key_buf = this.bitOff(this.key_buf, 1);
            } else if (n == 50) {
                this.key_buf = this.bitOff(this.key_buf, 2);
            } else if (n == 52) {
                this.key_buf = this.bitOff(this.key_buf, 4);
            } else if (n == 53) {
                this.key_buf = this.bitOff(this.key_buf, 5);
            } else if (n == 54) {
                this.key_buf = this.bitOff(this.key_buf, 6);
            } else if (n == 56) {
                this.key_buf = this.bitOff(this.key_buf, 8);
            } else if (n == 35) {
                this.key_buf = this.bitOff(this.key_buf, 11);
            } else if (n == 42) {
                this.key_buf = this.bitOff(this.key_buf, 10);
            } else if (n == -1) {
                this.key_buf = this.bitOff(this.key_buf, 12);
            } else if (n == -2) {
                this.key_buf = this.bitOff(this.key_buf, 15);
            } else if (n == -3) {
                this.key_buf = this.bitOff(this.key_buf, 13);
            } else if (n == -4) {
                this.key_buf = this.bitOff(this.key_buf, 14);
            } else if (n == -5) {
                this.key_buf = this.bitOff(this.key_buf, 16);
            } else if (n == -6) {
                this.key_buf = this.bitOff(this.key_buf, 17);
            } else if (n == -7) {
                this.key_buf = this.bitOff(this.key_buf, 18);
            }
        }

        public int bitOn(int n, int n2) {
            n = this.bitOff(n, n2);
            this.key_pressed = n |= 1 << n2;
            return n;
        }

        public int bitOff(int n, int n2) {
            return n &= ~(1 << n2);
        }

        public void paint(Graphics graphics) {
            gc = graphics;
            if (AgesBase.this.paint_flag) {
                graphics.setColor(0);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            keyData = this.getKeyState();
            keyRepeat = keyPush = keyData & ~keyLast;
            if (keyPush != 0) {
                keyCounter = 8;
            } else if (--keyCounter == 0) {
                keyRepeat = keyData;
                keyCounter = 2;
            }
            keyLast = keyData;
            ++commonCounter;
            boolean bl = AgesBase.this.paint_flag;
            AgesBase.this.paint_flag = false;
            graphics.setClip(offsetX, offsetY, 150, 170);
            AgesBase.this.game_synch(bl);
        }

        protected synchronized void hideNotify() {
            AgesBase.this.paint_flag = true;
            this.key_buf = 0;
            AgesBase.stopBgm();
            once = false;
            if (game_mode == 4) {
                key_pause = true;
            } else if (game_mode == 2) {
                game_mode = 3;
            }
        }

        protected synchronized void showNotify() {
            AgesBase.this.paint_flag = true;
            this.key_buf = 0;
        }
    }
}

