///------------------------------------------------------------------------
/// @file   NewProject.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_NewProject_H__ )
#define __SR_NewProject_H__

namespace surfride { 
namespace header { 

// V[
enum NewProject_Scenes
{
	Scene_NewProject_Root												= sr_scn_ofs * 1,
};

// C[
enum NewProject_Layers
{
	Layer_NewProject_Root_mz_dra												= Scene_NewProject_Root | sr_lyr_ofs * 1,
};

// Aj[V
enum NewProject_Animations
{
	Animation_NewProject_Root_mz_dra_norm_stan_loop												= Layer_NewProject_Root_mz_dra | sr_anm_ofs * 1,
	Animation_NewProject_Root_mz_dra_norm_smile												= Layer_NewProject_Root_mz_dra | sr_anm_ofs * 2,
	Animation_NewProject_Root_mz_dra_anger_anger												= Layer_NewProject_Root_mz_dra | sr_anm_ofs * 3,
	Animation_NewProject_Root_mz_dra_anger_surp												= Layer_NewProject_Root_mz_dra | sr_anm_ofs * 4,
	Animation_NewProject_Root_mz_dra_heta_heta												= Layer_NewProject_Root_mz_dra | sr_anm_ofs * 5,
	Animation_NewProject_Root_mz_dra_heta_diff												= Layer_NewProject_Root_mz_dra | sr_anm_ofs * 6,
	Animation_NewProject_Root_mz_dra_heta_weep												= Layer_NewProject_Root_mz_dra | sr_anm_ofs * 7,
	Animation_NewProject_Root_mz_dra_norm_surp												= Layer_NewProject_Root_mz_dra | sr_anm_ofs * 8,
};

// LXg
enum NewProject_Casts
{
	Cast_NewProject_Root_mz_dra_loop												= Layer_NewProject_Root_mz_dra | sr_cst_ofs * 1,
	Cast_NewProject_Root_mz_dra_norm_body												= Layer_NewProject_Root_mz_dra | sr_cst_ofs * 2,
	Cast_NewProject_Root_mz_dra_norm_body_norm_face												= Layer_NewProject_Root_mz_dra | sr_cst_ofs * 3,
	Cast_NewProject_Root_mz_dra_norm_body_Null_norm_stan_ef												= Layer_NewProject_Root_mz_dra | sr_cst_ofs * 4,
	Cast_NewProject_Root_mz_dra_norm_body_Null_norm_smile_ef												= Layer_NewProject_Root_mz_dra | sr_cst_ofs * 5,
	Cast_NewProject_Root_mz_dra_anger_body												= Layer_NewProject_Root_mz_dra | sr_cst_ofs * 6,
	Cast_NewProject_Root_mz_dra_anger_body_anger_face												= Layer_NewProject_Root_mz_dra | sr_cst_ofs * 7,
	Cast_NewProject_Root_mz_dra_anger_body_Null_anger_anger_ef												= Layer_NewProject_Root_mz_dra | sr_cst_ofs * 8,
	Cast_NewProject_Root_mz_dra_anger_body_Null_anger_surp_ef												= Layer_NewProject_Root_mz_dra | sr_cst_ofs * 9,
	Cast_NewProject_Root_mz_dra_heta_body												= Layer_NewProject_Root_mz_dra | sr_cst_ofs * 10,
	Cast_NewProject_Root_mz_dra_heta_body_heta_face												= Layer_NewProject_Root_mz_dra | sr_cst_ofs * 11,
	Cast_NewProject_Root_mz_dra_heta_body_Null_heta_heta_ef												= Layer_NewProject_Root_mz_dra | sr_cst_ofs * 12,
	Cast_NewProject_Root_mz_dra_heta_body_Null_heta_diff_ef												= Layer_NewProject_Root_mz_dra | sr_cst_ofs * 13,
	Cast_NewProject_Root_mz_dra_heta_body_Null_heta_weep_ef												= Layer_NewProject_Root_mz_dra | sr_cst_ofs * 14,
};

// t@XLXgĒ`
enum NewProject_Reference_Casts
{
};

// Aj[VZbg
enum NewProject_AnimationSets
{
};


// Ro[gNX
class NewProjectConverter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"Root",
	};

	const char* LayerNames[][2] = 
	{
		{
			"mz_dra",
		},
	};

	const char* AnimeNames[][2][9] = 
	{
		{
			{
				"norm_stan_loop",
				"norm_smile",
				"anger_anger",
				"anger_surp",
				"heta_heta",
				"heta_diff",
				"heta_weep",
				"norm_surp",
			},
		},
	};

	const char* CastNames[][2][15] = 
	{
		{
			{
				"loop",
				"norm_body",
				"norm_face",
				"Null_norm_stan_ef",
				"Null_norm_smile_ef",
				"anger_body",
				"anger_face",
				"Null_anger_anger_ef",
				"Null_anger_surp_ef",
				"heta_body",
				"heta_face",
				"Null_heta_heta_ef",
				"Null_heta_diff_ef",
				"Null_heta_weep_ef",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

