///------------------------------------------------------------------------
/// @file   NewProject.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_NewProject_H__ )
#define __SR_NewProject_H__

namespace surfride { 
namespace header { 

// V[
enum NewProject_Scenes
{
	Scene_NewProject_Root												= sr_scn_ofs * 1,
};

// C[
enum NewProject_Layers
{
	Layer_NewProject_Root_mz_klu												= Scene_NewProject_Root | sr_lyr_ofs * 1,
};

// Aj[V
enum NewProject_Animations
{
	Animation_NewProject_Root_mz_klu_norm_stan_loop												= Layer_NewProject_Root_mz_klu | sr_anm_ofs * 1,
	Animation_NewProject_Root_mz_klu_norm_eru												= Layer_NewProject_Root_mz_klu | sr_anm_ofs * 2,
	Animation_NewProject_Root_mz_klu_ibari_high												= Layer_NewProject_Root_mz_klu | sr_anm_ofs * 3,
	Animation_NewProject_Root_mz_klu_ibari_anger												= Layer_NewProject_Root_mz_klu | sr_anm_ofs * 4,
	Animation_NewProject_Root_mz_klu_fear_fright												= Layer_NewProject_Root_mz_klu | sr_anm_ofs * 5,
	Animation_NewProject_Root_mz_klu_fear_weep												= Layer_NewProject_Root_mz_klu | sr_anm_ofs * 6,
	Animation_NewProject_Root_mz_klu_norm_drunk1												= Layer_NewProject_Root_mz_klu | sr_anm_ofs * 7,
	Animation_NewProject_Root_mz_klu_norm_drunk2												= Layer_NewProject_Root_mz_klu | sr_anm_ofs * 8,
	Animation_NewProject_Root_mz_klu_ibari_drunk1												= Layer_NewProject_Root_mz_klu | sr_anm_ofs * 9,
	Animation_NewProject_Root_mz_klu_ibari_drunk2												= Layer_NewProject_Root_mz_klu | sr_anm_ofs * 10,
};

// LXg
enum NewProject_Casts
{
	Cast_NewProject_Root_mz_klu_loop												= Layer_NewProject_Root_mz_klu | sr_cst_ofs * 1,
	Cast_NewProject_Root_mz_klu_norm												= Layer_NewProject_Root_mz_klu | sr_cst_ofs * 2,
	Cast_NewProject_Root_mz_klu_norm_norm_arm1												= Layer_NewProject_Root_mz_klu | sr_cst_ofs * 3,
	Cast_NewProject_Root_mz_klu_norm_norm_arm2												= Layer_NewProject_Root_mz_klu | sr_cst_ofs * 4,
	Cast_NewProject_Root_mz_klu_norm_norm_body												= Layer_NewProject_Root_mz_klu | sr_cst_ofs * 5,
	Cast_NewProject_Root_mz_klu_norm_norm_face												= Layer_NewProject_Root_mz_klu | sr_cst_ofs * 6,
	Cast_NewProject_Root_mz_klu_norm_norm_efe												= Layer_NewProject_Root_mz_klu | sr_cst_ofs * 7,
	Cast_NewProject_Root_mz_klu_norm_Null_norm_stan_ef												= Layer_NewProject_Root_mz_klu | sr_cst_ofs * 8,
	Cast_NewProject_Root_mz_klu_norm_Null_norm_eru_ef												= Layer_NewProject_Root_mz_klu | sr_cst_ofs * 9,
	Cast_NewProject_Root_mz_klu_ibari												= Layer_NewProject_Root_mz_klu | sr_cst_ofs * 10,
	Cast_NewProject_Root_mz_klu_ibari_ibari_body												= Layer_NewProject_Root_mz_klu | sr_cst_ofs * 11,
	Cast_NewProject_Root_mz_klu_ibari_ibari_face												= Layer_NewProject_Root_mz_klu | sr_cst_ofs * 12,
	Cast_NewProject_Root_mz_klu_ibari_Null_ibari_high_ef												= Layer_NewProject_Root_mz_klu | sr_cst_ofs * 13,
	Cast_NewProject_Root_mz_klu_ibari_Null_ibari_anger_ef												= Layer_NewProject_Root_mz_klu | sr_cst_ofs * 14,
	Cast_NewProject_Root_mz_klu_fear												= Layer_NewProject_Root_mz_klu | sr_cst_ofs * 15,
	Cast_NewProject_Root_mz_klu_fear_fear_body												= Layer_NewProject_Root_mz_klu | sr_cst_ofs * 16,
	Cast_NewProject_Root_mz_klu_fear_fear_face												= Layer_NewProject_Root_mz_klu | sr_cst_ofs * 17,
	Cast_NewProject_Root_mz_klu_fear_Null_fear_fright_ef												= Layer_NewProject_Root_mz_klu | sr_cst_ofs * 18,
	Cast_NewProject_Root_mz_klu_fear_Null_fear_weep_ef												= Layer_NewProject_Root_mz_klu | sr_cst_ofs * 19,
};

// t@XLXgĒ`
enum NewProject_Reference_Casts
{
};

// Aj[VZbg
enum NewProject_AnimationSets
{
};


// Ro[gNX
class NewProjectConverter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"Root",
	};

	const char* LayerNames[][2] = 
	{
		{
			"mz_klu",
		},
	};

	const char* AnimeNames[][2][11] = 
	{
		{
			{
				"norm_stan_loop",
				"norm_eru",
				"ibari_high",
				"ibari_anger",
				"fear_fright",
				"fear_weep",
				"norm_drunk1",
				"norm_drunk2",
				"ibari_drunk1",
				"ibari_drunk2",
			},
		},
	};

	const char* CastNames[][2][20] = 
	{
		{
			{
				"loop",
				"norm",
				"norm_arm1",
				"norm_arm2",
				"norm_body",
				"norm_face",
				"norm_efe",
				"Null_norm_stan_ef",
				"Null_norm_eru_ef",
				"ibari",
				"ibari_body",
				"ibari_face",
				"Null_ibari_high_ef",
				"Null_ibari_anger_ef",
				"fear",
				"fear_body",
				"fear_face",
				"Null_fear_fright_ef",
				"Null_fear_weep_ef",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

