///------------------------------------------------------------------------
/// @file   NewProject.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_NewProject_H__ )
#define __SR_NewProject_H__

namespace surfride { 
namespace header { 

// V[
enum NewProject_Scenes
{
	Scene_NewProject_Root												= sr_scn_ofs * 1,
};

// C[
enum NewProject_Layers
{
	Layer_NewProject_Root_mz_rul												= Scene_NewProject_Root | sr_lyr_ofs * 1,
	Layer_NewProject_Root_mask												= Scene_NewProject_Root | sr_lyr_ofs * 2,
};

// Aj[V
enum NewProject_Animations
{
	Animation_NewProject_Root_mz_rul_norm_stan_loop												= Layer_NewProject_Root_mz_rul | sr_anm_ofs * 1,
	Animation_NewProject_Root_mz_rul_norm_anger												= Layer_NewProject_Root_mz_rul | sr_anm_ofs * 2,
	Animation_NewProject_Root_mz_rul_anger_reg												= Layer_NewProject_Root_mz_rul | sr_anm_ofs * 3,
	Animation_NewProject_Root_mz_rul_anger_fury												= Layer_NewProject_Root_mz_rul | sr_anm_ofs * 4,
	Animation_NewProject_Root_mz_rul_laugh_high												= Layer_NewProject_Root_mz_rul | sr_anm_ofs * 5,
	Animation_NewProject_Root_mz_rul_laugh_mad												= Layer_NewProject_Root_mz_rul | sr_anm_ofs * 6,
};

// LXg
enum NewProject_Casts
{
	Cast_NewProject_Root_mz_rul_loop												= Layer_NewProject_Root_mz_rul | sr_cst_ofs * 1,
	Cast_NewProject_Root_mz_rul_norm_stan												= Layer_NewProject_Root_mz_rul | sr_cst_ofs * 2,
	Cast_NewProject_Root_mz_rul_norm_stan_face_stan												= Layer_NewProject_Root_mz_rul | sr_cst_ofs * 3,
	Cast_NewProject_Root_mz_rul_norm_stan_Null_norm_stan_ef												= Layer_NewProject_Root_mz_rul | sr_cst_ofs * 4,
	Cast_NewProject_Root_mz_rul_norm_anger												= Layer_NewProject_Root_mz_rul | sr_cst_ofs * 5,
	Cast_NewProject_Root_mz_rul_norm_anger_face_anger												= Layer_NewProject_Root_mz_rul | sr_cst_ofs * 6,
	Cast_NewProject_Root_mz_rul_norm_anger_Null_norm_anger_ef												= Layer_NewProject_Root_mz_rul | sr_cst_ofs * 7,
	Cast_NewProject_Root_mz_rul_anger_reg												= Layer_NewProject_Root_mz_rul | sr_cst_ofs * 8,
	Cast_NewProject_Root_mz_rul_anger_reg_face_reg												= Layer_NewProject_Root_mz_rul | sr_cst_ofs * 9,
	Cast_NewProject_Root_mz_rul_anger_reg_Null_anger_reg_ef												= Layer_NewProject_Root_mz_rul | sr_cst_ofs * 10,
	Cast_NewProject_Root_mz_rul_anger_fury												= Layer_NewProject_Root_mz_rul | sr_cst_ofs * 11,
	Cast_NewProject_Root_mz_rul_anger_fury_face_fury												= Layer_NewProject_Root_mz_rul | sr_cst_ofs * 12,
	Cast_NewProject_Root_mz_rul_anger_fury_Null_anger_fury_ef												= Layer_NewProject_Root_mz_rul | sr_cst_ofs * 13,
	Cast_NewProject_Root_mz_rul_laugh_body												= Layer_NewProject_Root_mz_rul | sr_cst_ofs * 14,
	Cast_NewProject_Root_mz_rul_laugh_body_laugh_face												= Layer_NewProject_Root_mz_rul | sr_cst_ofs * 15,
	Cast_NewProject_Root_mz_rul_laugh_body_laugh_hand												= Layer_NewProject_Root_mz_rul | sr_cst_ofs * 16,
	Cast_NewProject_Root_mz_rul_laugh_body_laugh_sensu												= Layer_NewProject_Root_mz_rul | sr_cst_ofs * 17,
	Cast_NewProject_Root_mz_rul_laugh_body_Null_laugh_mad_ef												= Layer_NewProject_Root_mz_rul | sr_cst_ofs * 18,
	Cast_NewProject_Root_mz_rul_laugh_body_Null_laugh_high_ef												= Layer_NewProject_Root_mz_rul | sr_cst_ofs * 19,
	Cast_NewProject_Root_mask_move_point												= Layer_NewProject_Root_mask | sr_cst_ofs * 1,
	Cast_NewProject_Root_mask_move_point_mask												= Layer_NewProject_Root_mask | sr_cst_ofs * 2,
};

// t@XLXgĒ`
enum NewProject_Reference_Casts
{
};

// Aj[VZbg
enum NewProject_AnimationSets
{
};


// Ro[gNX
class NewProjectConverter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"Root",
	};

	const char* LayerNames[][3] = 
	{
		{
			"mz_rul",
			"mask",
		},
	};

	const char* AnimeNames[][3][7] = 
	{
		{
			{
				"norm_stan_loop",
				"norm_anger",
				"anger_reg",
				"anger_fury",
				"laugh_high",
				"laugh_mad",
			},
			{
			},
		},
	};

	const char* CastNames[][3][20] = 
	{
		{
			{
				"loop",
				"norm_stan",
				"face_stan",
				"Null_norm_stan_ef",
				"norm_anger",
				"face_anger",
				"Null_norm_anger_ef",
				"anger_reg",
				"face_reg",
				"Null_anger_reg_ef",
				"anger_fury",
				"face_fury",
				"Null_anger_fury_ef",
				"laugh_body",
				"laugh_face",
				"laugh_hand",
				"laugh_sensu",
				"Null_laugh_mad_ef",
				"Null_laugh_high_ef",
			},
			{
				"move_point",
				"mask",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

