///------------------------------------------------------------------------
/// @file   NewProject.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_NewProject_H__ )
#define __SR_NewProject_H__

namespace surfride { 
namespace header { 

// V[
enum NewProject_Scenes
{
	Scene_NewProject_Root												= sr_scn_ofs * 1,
};

// C[
enum NewProject_Layers
{
	Layer_NewProject_Root_mz_shz												= Scene_NewProject_Root | sr_lyr_ofs * 1,
	Layer_NewProject_Root_mask												= Scene_NewProject_Root | sr_lyr_ofs * 2,
};

// Aj[V
enum NewProject_Animations
{
	Animation_NewProject_Root_mz_shz_norm_stan_loop												= Layer_NewProject_Root_mz_shz | sr_anm_ofs * 1,
	Animation_NewProject_Root_mz_shz_norm_diff												= Layer_NewProject_Root_mz_shz | sr_anm_ofs * 2,
	Animation_NewProject_Root_mz_shz_anger_anger												= Layer_NewProject_Root_mz_shz | sr_anm_ofs * 3,
	Animation_NewProject_Root_mz_shz_anger_surp												= Layer_NewProject_Root_mz_shz | sr_anm_ofs * 4,
	Animation_NewProject_Root_mz_shz_puyo_smile												= Layer_NewProject_Root_mz_shz | sr_anm_ofs * 5,
	Animation_NewProject_Root_mz_shz_puyo_serious												= Layer_NewProject_Root_mz_shz | sr_anm_ofs * 6,
	Animation_NewProject_Root_mz_shz_norm_surp												= Layer_NewProject_Root_mz_shz | sr_anm_ofs * 7,
};

// LXg
enum NewProject_Casts
{
	Cast_NewProject_Root_mz_shz_loop												= Layer_NewProject_Root_mz_shz | sr_cst_ofs * 1,
	Cast_NewProject_Root_mz_shz_norm												= Layer_NewProject_Root_mz_shz | sr_cst_ofs * 2,
	Cast_NewProject_Root_mz_shz_norm_norm_face												= Layer_NewProject_Root_mz_shz | sr_cst_ofs * 3,
	Cast_NewProject_Root_mz_shz_norm_Null_norm_stan_ef												= Layer_NewProject_Root_mz_shz | sr_cst_ofs * 4,
	Cast_NewProject_Root_mz_shz_norm_Null_norm_diff_ef												= Layer_NewProject_Root_mz_shz | sr_cst_ofs * 5,
	Cast_NewProject_Root_mz_shz_anger_anger												= Layer_NewProject_Root_mz_shz | sr_cst_ofs * 6,
	Cast_NewProject_Root_mz_shz_anger_anger_face_anger												= Layer_NewProject_Root_mz_shz | sr_cst_ofs * 7,
	Cast_NewProject_Root_mz_shz_anger_anger_Null_anger_anger_ef												= Layer_NewProject_Root_mz_shz | sr_cst_ofs * 8,
	Cast_NewProject_Root_mz_shz_anger_surp												= Layer_NewProject_Root_mz_shz | sr_cst_ofs * 9,
	Cast_NewProject_Root_mz_shz_anger_surp_face_surp												= Layer_NewProject_Root_mz_shz | sr_cst_ofs * 10,
	Cast_NewProject_Root_mz_shz_anger_surp_Null_anger_surp_ef												= Layer_NewProject_Root_mz_shz | sr_cst_ofs * 11,
	Cast_NewProject_Root_mz_shz_puyo_body												= Layer_NewProject_Root_mz_shz | sr_cst_ofs * 12,
	Cast_NewProject_Root_mz_shz_puyo_body_puyo_face												= Layer_NewProject_Root_mz_shz | sr_cst_ofs * 13,
	Cast_NewProject_Root_mz_shz_puyo_body_Null_puyo_smile_ef												= Layer_NewProject_Root_mz_shz | sr_cst_ofs * 14,
	Cast_NewProject_Root_mz_shz_puyo_body_Null_puyo_serious_ef												= Layer_NewProject_Root_mz_shz | sr_cst_ofs * 15,
	Cast_NewProject_Root_mask_move_point												= Layer_NewProject_Root_mask | sr_cst_ofs * 1,
	Cast_NewProject_Root_mask_move_point_mask												= Layer_NewProject_Root_mask | sr_cst_ofs * 2,
};

// t@XLXgĒ`
enum NewProject_Reference_Casts
{
};

// Aj[VZbg
enum NewProject_AnimationSets
{
};


// Ro[gNX
class NewProjectConverter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"Root",
	};

	const char* LayerNames[][3] = 
	{
		{
			"mz_shz",
			"mask",
		},
	};

	const char* AnimeNames[][3][8] = 
	{
		{
			{
				"norm_stan_loop",
				"norm_diff",
				"anger_anger",
				"anger_surp",
				"puyo_smile",
				"puyo_serious",
				"norm_surp",
			},
			{
			},
		},
	};

	const char* CastNames[][3][16] = 
	{
		{
			{
				"loop",
				"norm",
				"norm_face",
				"Null_norm_stan_ef",
				"Null_norm_diff_ef",
				"anger_anger",
				"face_anger",
				"Null_anger_anger_ef",
				"anger_surp",
				"face_surp",
				"Null_anger_surp_ef",
				"puyo_body",
				"puyo_face",
				"Null_puyo_smile_ef",
				"Null_puyo_serious_ef",
			},
			{
				"move_point",
				"mask",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

