///------------------------------------------------------------------------
/// @file   NewProject.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_NewProject_H__ )
#define __SR_NewProject_H__

namespace surfride { 
namespace header { 

// V[
enum NewProject_Scenes
{
	Scene_NewProject_Root												= sr_scn_ofs * 1,
};

// C[
enum NewProject_Layers
{
	Layer_NewProject_Root_mz_sig_l												= Scene_NewProject_Root | sr_lyr_ofs * 1,
	Layer_NewProject_Root_mask												= Scene_NewProject_Root | sr_lyr_ofs * 2,
};

// Aj[V
enum NewProject_Animations
{
	Animation_NewProject_Root_mz_sig_l_norm_stan_loop												= Layer_NewProject_Root_mz_sig_l | sr_anm_ofs * 1,
	Animation_NewProject_Root_mz_sig_l_norm_smile												= Layer_NewProject_Root_mz_sig_l | sr_anm_ofs * 2,
	Animation_NewProject_Root_mz_sig_l_puyo_poker												= Layer_NewProject_Root_mz_sig_l | sr_anm_ofs * 3,
	Animation_NewProject_Root_mz_sig_l_puyo_serious												= Layer_NewProject_Root_mz_sig_l | sr_anm_ofs * 4,
	Animation_NewProject_Root_mz_sig_l_think												= Layer_NewProject_Root_mz_sig_l | sr_anm_ofs * 5,
	Animation_NewProject_Root_mz_sig_l_thin2												= Layer_NewProject_Root_mz_sig_l | sr_anm_ofs * 6,
};

// LXg
enum NewProject_Casts
{
	Cast_NewProject_Root_mz_sig_l_loop												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 1,
	Cast_NewProject_Root_mz_sig_l_norm												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 2,
	Cast_NewProject_Root_mz_sig_l_norm_norm_antena												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 3,
	Cast_NewProject_Root_mz_sig_l_norm_norm_body												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 4,
	Cast_NewProject_Root_mz_sig_l_norm_norm_face												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 5,
	Cast_NewProject_Root_mz_sig_l_norm_norm_bug												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 6,
	Cast_NewProject_Root_mz_sig_l_norm_norm_bug_Cast_0092												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 7,
	Cast_NewProject_Root_mz_sig_l_norm_Null_norm_stan_ef												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 8,
	Cast_NewProject_Root_mz_sig_l_norm_Null_smile_stan_ef												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 9,
	Cast_NewProject_Root_mz_sig_l_puyo												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 10,
	Cast_NewProject_Root_mz_sig_l_puyo_puyo_antena												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 11,
	Cast_NewProject_Root_mz_sig_l_puyo_puyo_body												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 12,
	Cast_NewProject_Root_mz_sig_l_puyo_puyo_face												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 13,
	Cast_NewProject_Root_mz_sig_l_puyo_puyo_bug												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 14,
	Cast_NewProject_Root_mz_sig_l_puyo_Null_puyo_serious_ef												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 15,
	Cast_NewProject_Root_mz_sig_l_puyo_Null_puyo_poker_ef												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 16,
	Cast_NewProject_Root_mz_sig_l_think												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 17,
	Cast_NewProject_Root_mz_sig_l_think_think_soul												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 18,
	Cast_NewProject_Root_mz_sig_l_think_think_body												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 19,
	Cast_NewProject_Root_mz_sig_l_think_think_face												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 20,
	Cast_NewProject_Root_mz_sig_l_think_think_bug												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 21,
	Cast_NewProject_Root_mz_sig_l_think_Null_think_ef												= Layer_NewProject_Root_mz_sig_l | sr_cst_ofs * 22,
	Cast_NewProject_Root_mask_move_point												= Layer_NewProject_Root_mask | sr_cst_ofs * 1,
	Cast_NewProject_Root_mask_move_point_mask												= Layer_NewProject_Root_mask | sr_cst_ofs * 2,
};

// t@XLXgĒ`
enum NewProject_Reference_Casts
{
};

// Aj[VZbg
enum NewProject_AnimationSets
{
};


// Ro[gNX
class NewProjectConverter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"Root",
	};

	const char* LayerNames[][3] = 
	{
		{
			"mz_sig_l",
			"mask",
		},
	};

	const char* AnimeNames[][3][7] = 
	{
		{
			{
				"norm_stan_loop",
				"norm_smile",
				"puyo_poker",
				"puyo_serious",
				"think",
				"thin2",
			},
			{
			},
		},
	};

	const char* CastNames[][3][23] = 
	{
		{
			{
				"loop",
				"norm",
				"norm_antena",
				"norm_body",
				"norm_face",
				"norm_bug",
				"Cast_0092",
				"Null_norm_stan_ef",
				"Null_smile_stan_ef",
				"puyo",
				"puyo_antena",
				"puyo_body",
				"puyo_face",
				"puyo_bug",
				"Null_puyo_serious_ef",
				"Null_puyo_poker_ef",
				"think",
				"think_soul",
				"think_body",
				"think_face",
				"think_bug",
				"Null_think_ef",
			},
			{
				"move_point",
				"mask",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

