///------------------------------------------------------------------------
/// @file   V010_Continue_00.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_V010_Continue_00_H__ )
#define __SR_V010_Continue_00_H__

namespace surfride { 
namespace header { 

// V[
enum V010_Continue_00_Scenes
{
	Scene_V010_Continue_00_V010_Continue_00												= sr_scn_ofs * 1,
};

// C[
enum V010_Continue_00_Layers
{
	Layer_V010_Continue_00_V010_Continue_00_Continue												= Scene_V010_Continue_00_V010_Continue_00 | sr_lyr_ofs * 1,
	Layer_V010_Continue_00_V010_Continue_00_gameover												= Scene_V010_Continue_00_V010_Continue_00 | sr_lyr_ofs * 2,
};

// Aj[V
enum V010_Continue_00_Animations
{
	Animation_V010_Continue_00_V010_Continue_00_Continue_All_in												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_anm_ofs * 1,
	Animation_V010_Continue_00_V010_Continue_00_Continue_count_down												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_anm_ofs * 2,
	Animation_V010_Continue_00_V010_Continue_00_Continue_bt_loop												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_anm_ofs * 3,
	Animation_V010_Continue_00_V010_Continue_00_Continue_bt_out												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_anm_ofs * 4,
	Animation_V010_Continue_00_V010_Continue_00_Continue_All_out												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_anm_ofs * 5,
	Animation_V010_Continue_00_V010_Continue_00_gameover_All_in												= Layer_V010_Continue_00_V010_Continue_00_gameover | sr_anm_ofs * 1,
	Animation_V010_Continue_00_V010_Continue_00_gameover_loop												= Layer_V010_Continue_00_V010_Continue_00_gameover | sr_anm_ofs * 2,
	Animation_V010_Continue_00_V010_Continue_00_gameover_All_out												= Layer_V010_Continue_00_V010_Continue_00_gameover | sr_anm_ofs * 3,
};

// LXg
enum V010_Continue_00_Casts
{
	Cast_V010_Continue_00_V010_Continue_00_Continue_move_point												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_cst_ofs * 1,
	Cast_V010_Continue_00_V010_Continue_00_Continue_move_point_base_b												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_cst_ofs * 2,
	Cast_V010_Continue_00_V010_Continue_00_Continue_move_point_anim_point												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_cst_ofs * 3,
	Cast_V010_Continue_00_V010_Continue_00_Continue_move_point_anim_point_base												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_cst_ofs * 4,
	Cast_V010_Continue_00_V010_Continue_00_Continue_move_point_anim_point_base_base_00												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_cst_ofs * 5,
	Cast_V010_Continue_00_V010_Continue_00_Continue_move_point_anim_point_base_base_00_chara												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_cst_ofs * 6,
	Cast_V010_Continue_00_V010_Continue_00_Continue_move_point_anim_point_base_continue												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_cst_ofs * 7,
	Cast_V010_Continue_00_V010_Continue_00_Continue_move_point_anim_point_base_text												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_cst_ofs * 8,
	Cast_V010_Continue_00_V010_Continue_00_Continue_move_point_anim_point_bt												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_cst_ofs * 9,
	Cast_V010_Continue_00_V010_Continue_00_Continue_move_point_anim_point_bt_bt_yes												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_cst_ofs * 10,
	Cast_V010_Continue_00_V010_Continue_00_Continue_move_point_anim_point_bt_bt_yes_yes												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_cst_ofs * 11,
	Cast_V010_Continue_00_V010_Continue_00_Continue_move_point_anim_point_bt_bt_no												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_cst_ofs * 12,
	Cast_V010_Continue_00_V010_Continue_00_Continue_move_point_anim_point_bt_bt_no_no												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_cst_ofs * 13,
	Cast_V010_Continue_00_V010_Continue_00_Continue_move_point_anim_point_time												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_cst_ofs * 14,
	Cast_V010_Continue_00_V010_Continue_00_Continue_move_point_anim_point_time_number												= Layer_V010_Continue_00_V010_Continue_00_Continue | sr_cst_ofs * 15,
	Cast_V010_Continue_00_V010_Continue_00_gameover_move_point1												= Layer_V010_Continue_00_V010_Continue_00_gameover | sr_cst_ofs * 1,
	Cast_V010_Continue_00_V010_Continue_00_gameover_move_point1_base_00												= Layer_V010_Continue_00_V010_Continue_00_gameover | sr_cst_ofs * 2,
	Cast_V010_Continue_00_V010_Continue_00_gameover_move_point1_base												= Layer_V010_Continue_00_V010_Continue_00_gameover | sr_cst_ofs * 3,
	Cast_V010_Continue_00_V010_Continue_00_gameover_move_point1_base_game												= Layer_V010_Continue_00_V010_Continue_00_gameover | sr_cst_ofs * 4,
	Cast_V010_Continue_00_V010_Continue_00_gameover_move_point1_base_game_over												= Layer_V010_Continue_00_V010_Continue_00_gameover | sr_cst_ofs * 5,
	Cast_V010_Continue_00_V010_Continue_00_gameover_move_point1_arl												= Layer_V010_Continue_00_V010_Continue_00_gameover | sr_cst_ofs * 6,
};

// t@XLXgĒ`
enum V010_Continue_00_Reference_Casts
{
};


// Ro[gNX
class V010_Continue_00Converter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"V010_Continue_00",
	};

	const char* LayerNames[][3] = 
	{
		{
			"Continue",
			"gameover",
		},
	};

	const char* AnimeNames[][3][6] = 
	{
		{
			{
				"All_in",
				"count_down",
				"bt_loop",
				"bt_out",
				"All_out",
			},
			{
				"All_in",
				"loop",
				"All_out",
			},
		},
	};

	const char* CastNames[][3][16] = 
	{
		{
			{
				"move_point",
				"base_b",
				"anim_point",
				"base",
				"base_00",
				"chara",
				"continue",
				"text",
				"bt",
				"bt_yes",
				"yes",
				"bt_no",
				"no",
				"time",
				"number",
			},
			{
				"move_point1",
				"base_00",
				"base",
				"game",
				"over",
				"arl",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

