///------------------------------------------------------------------------
/// @file   V010_FontTest_00.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_V010_FontTest_00_H__ )
#define __SR_V010_FontTest_00_H__

namespace surfride { 
namespace header { 

// V[
enum V010_FontTest_00_Scenes
{
	Scene_V010_FontTest_00_V010_FontTest_00												= sr_scn_ofs * 1,
};

// C[
enum V010_FontTest_00_Layers
{
	Layer_V010_FontTest_00_V010_FontTest_00_2D												= Scene_V010_FontTest_00_V010_FontTest_00 | sr_lyr_ofs * 1,
	Layer_V010_FontTest_00_V010_FontTest_00_3D												= Scene_V010_FontTest_00_V010_FontTest_00 | sr_lyr_ofs * 2,
};

// Aj[V
enum V010_FontTest_00_Animations
{
	Animation_V010_FontTest_00_V010_FontTest_00_2D_Animation_0001												= Layer_V010_FontTest_00_V010_FontTest_00_2D | sr_anm_ofs * 1,
	Animation_V010_FontTest_00_V010_FontTest_00_3D_loop												= Layer_V010_FontTest_00_V010_FontTest_00_3D | sr_anm_ofs * 1,
};

// LXg
enum V010_FontTest_00_Casts
{
	Cast_V010_FontTest_00_V010_FontTest_00_2D_BK												= Layer_V010_FontTest_00_V010_FontTest_00_2D | sr_cst_ofs * 1,
	Cast_V010_FontTest_00_V010_FontTest_00_2D_FiT1KNewCezanne-M-U												= Layer_V010_FontTest_00_V010_FontTest_00_2D | sr_cst_ofs * 2,
	Cast_V010_FontTest_00_V010_FontTest_00_2D_FiT1KSEGA_KakuGothic-DB-U												= Layer_V010_FontTest_00_V010_FontTest_00_2D | sr_cst_ofs * 3,
	Cast_V010_FontTest_00_V010_FontTest_00_2D_PopHappinessStd-EB												= Layer_V010_FontTest_00_V010_FontTest_00_2D | sr_cst_ofs * 4,
	Cast_V010_FontTest_00_V010_FontTest_00_2D_SlumpStd-DB												= Layer_V010_FontTest_00_V010_FontTest_00_2D | sr_cst_ofs * 5,
	Cast_V010_FontTest_00_V010_FontTest_00_3D_BK1												= Layer_V010_FontTest_00_V010_FontTest_00_3D | sr_cst_ofs * 1,
	Cast_V010_FontTest_00_V010_FontTest_00_3D_Cast_0021												= Layer_V010_FontTest_00_V010_FontTest_00_3D | sr_cst_ofs * 2,
	Cast_V010_FontTest_00_V010_FontTest_00_3D_Cast_0021_FiT1KSEGA_KakuGothic-DB-U1												= Layer_V010_FontTest_00_V010_FontTest_00_3D | sr_cst_ofs * 3,
	Cast_V010_FontTest_00_V010_FontTest_00_3D_Cast_0021_FiT1KNewCezanne-M-U1												= Layer_V010_FontTest_00_V010_FontTest_00_3D | sr_cst_ofs * 4,
	Cast_V010_FontTest_00_V010_FontTest_00_3D_Cast_0021_PopHappinessStd-EB1												= Layer_V010_FontTest_00_V010_FontTest_00_3D | sr_cst_ofs * 5,
	Cast_V010_FontTest_00_V010_FontTest_00_3D_Cast_0021_SlumpStd-DB1												= Layer_V010_FontTest_00_V010_FontTest_00_3D | sr_cst_ofs * 6,
};

// t@XLXgĒ`
enum V010_FontTest_00_Reference_Casts
{
};


// Ro[gNX
class V010_FontTest_00Converter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"V010_FontTest_00",
	};

	const char* LayerNames[][3] = 
	{
		{
			"2D",
			"3D",
		},
	};

	const char* AnimeNames[][3][2] = 
	{
		{
			{
				"Animation_0001",
			},
			{
				"loop",
			},
		},
	};

	const char* CastNames[][3][7] = 
	{
		{
			{
				"BK",
				"FiT1KNewCezanne-M-U",
				"FiT1KSEGA_KakuGothic-DB-U",
				"PopHappinessStd-EB",
				"SlumpStd-DB",
			},
			{
				"BK1",
				"Cast_0021",
				"FiT1KSEGA_KakuGothic-DB-U1",
				"FiT1KNewCezanne-M-U1",
				"PopHappinessStd-EB1",
				"SlumpStd-DB1",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

