///------------------------------------------------------------------------
/// @file   v0100_bg_type_00.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_v0100_bg_type_00_H__ )
#define __SR_v0100_bg_type_00_H__

namespace surfride { 
namespace header { 

// V[
enum v0100_bg_type_00_Scenes
{
	Scene_v0100_bg_type_00_v0100_bg_type_00												= sr_scn_ofs * 1,
};

// C[
enum v0100_bg_type_00_Layers
{
	Layer_v0100_bg_type_00_v0100_bg_type_00_BG												= Scene_v0100_bg_type_00_v0100_bg_type_00 | sr_lyr_ofs * 1,
};

// Aj[V
enum v0100_bg_type_00_Animations
{
	Animation_v0100_bg_type_00_v0100_bg_type_00_BG_all_in												= Layer_v0100_bg_type_00_v0100_bg_type_00_BG | sr_anm_ofs * 1,
	Animation_v0100_bg_type_00_v0100_bg_type_00_BG_all_out												= Layer_v0100_bg_type_00_v0100_bg_type_00_BG | sr_anm_ofs * 2,
	Animation_v0100_bg_type_00_v0100_bg_type_00_BG_loop												= Layer_v0100_bg_type_00_v0100_bg_type_00_BG | sr_anm_ofs * 3,
};

// LXg
enum v0100_bg_type_00_Casts
{
	Cast_v0100_bg_type_00_v0100_bg_type_00_BG_move_point_0_0												= Layer_v0100_bg_type_00_v0100_bg_type_00_BG | sr_cst_ofs * 1,
	Cast_v0100_bg_type_00_v0100_bg_type_00_BG_move_point_0_0_point												= Layer_v0100_bg_type_00_v0100_bg_type_00_BG | sr_cst_ofs * 2,
	Cast_v0100_bg_type_00_v0100_bg_type_00_BG_move_point_0_0_point_bg												= Layer_v0100_bg_type_00_v0100_bg_type_00_BG | sr_cst_ofs * 3,
};

// t@XLXgĒ`
enum v0100_bg_type_00_Reference_Casts
{
};

// Aj[VZbg
enum v0100_bg_type_00_AnimationSets
{
	AnimationSet_v0100_bg_type_00_v0100_bg_type_00_SHOUKAN_01												= sr_sol_ofs * 1 | Scene_v0100_bg_type_00_v0100_bg_type_00 | sr_set_ofs * 1,
	AnimationSet_v0100_bg_type_00_v0100_bg_type_00_SHOUKAN_02												= sr_sol_ofs * 1 | Scene_v0100_bg_type_00_v0100_bg_type_00 | sr_set_ofs * 2,
	AnimationSet_v0100_bg_type_00_v0100_bg_type_00_SHOUKAN_03												= sr_sol_ofs * 1 | Scene_v0100_bg_type_00_v0100_bg_type_00 | sr_set_ofs * 3,
	AnimationSet_v0100_bg_type_00_v0100_bg_type_00_SHOUKAN_04												= sr_sol_ofs * 1 | Scene_v0100_bg_type_00_v0100_bg_type_00 | sr_set_ofs * 4,
	AnimationSet_v0100_bg_type_00_v0100_bg_type_00_SHOUKAN_05												= sr_sol_ofs * 1 | Scene_v0100_bg_type_00_v0100_bg_type_00 | sr_set_ofs * 5,
	AnimationSet_v0100_bg_type_00_v0100_bg_type_00_SHOUKAN_06												= sr_sol_ofs * 1 | Scene_v0100_bg_type_00_v0100_bg_type_00 | sr_set_ofs * 6,
	AnimationSet_v0100_bg_type_00_v0100_bg_type_00_SHOUKAN_07												= sr_sol_ofs * 1 | Scene_v0100_bg_type_00_v0100_bg_type_00 | sr_set_ofs * 7,
	AnimationSet_v0100_bg_type_00_v0100_bg_type_00_SHOUKAN_08												= sr_sol_ofs * 1 | Scene_v0100_bg_type_00_v0100_bg_type_00 | sr_set_ofs * 8,
	AnimationSet_v0100_bg_type_00_v0100_bg_type_00_SHOUKAN_09												= sr_sol_ofs * 1 | Scene_v0100_bg_type_00_v0100_bg_type_00 | sr_set_ofs * 9,
	AnimationSet_v0100_bg_type_00_v0100_bg_type_00_SHOUKAN_10												= sr_sol_ofs * 1 | Scene_v0100_bg_type_00_v0100_bg_type_00 | sr_set_ofs * 10,
};


// Ro[gNX
class v0100_bg_type_00Converter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"v0100_bg_type_00",
	};

	const char* LayerNames[][2] = 
	{
		{
			"BG",
		},
	};

	const char* AnimeNames[][2][4] = 
	{
		{
			{
				"all_in",
				"all_out",
				"loop",
			},
		},
	};

	const char* CastNames[][2][4] = 
	{
		{
			{
				"move_point_0_0",
				"point",
				"bg",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

