///------------------------------------------------------------------------
/// @file   v0100_continue_00.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_v0100_continue_00_H__ )
#define __SR_v0100_continue_00_H__

namespace surfride { 
namespace header { 

// V[
enum v0100_continue_00_Scenes
{
	Scene_v0100_continue_00_v0100_continue_00												= sr_scn_ofs * 1,
};

// C[
enum v0100_continue_00_Layers
{
	Layer_v0100_continue_00_v0100_continue_00_base												= Scene_v0100_continue_00_v0100_continue_00 | sr_lyr_ofs * 1,
	Layer_v0100_continue_00_v0100_continue_00_text_continue												= Scene_v0100_continue_00_v0100_continue_00 | sr_lyr_ofs * 2,
	Layer_v0100_continue_00_v0100_continue_00_Reference_text												= Scene_v0100_continue_00_v0100_continue_00 | sr_lyr_ofs * 3,
	Layer_v0100_continue_00_v0100_continue_00_Reference_kazari												= Scene_v0100_continue_00_v0100_continue_00 | sr_lyr_ofs * 4,
};

// Aj[V
enum v0100_continue_00_Animations
{
	Animation_v0100_continue_00_v0100_continue_00_base_All_in												= Layer_v0100_continue_00_v0100_continue_00_base | sr_anm_ofs * 1,
	Animation_v0100_continue_00_v0100_continue_00_base_All_loop												= Layer_v0100_continue_00_v0100_continue_00_base | sr_anm_ofs * 2,
	Animation_v0100_continue_00_v0100_continue_00_base_All_out_bt_yes												= Layer_v0100_continue_00_v0100_continue_00_base | sr_anm_ofs * 3,
	Animation_v0100_continue_00_v0100_continue_00_base_All_out_bt_no												= Layer_v0100_continue_00_v0100_continue_00_base | sr_anm_ofs * 4,
	Animation_v0100_continue_00_v0100_continue_00_text_continue_All_in												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_anm_ofs * 1,
	Animation_v0100_continue_00_v0100_continue_00_text_continue_All_loop												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_anm_ofs * 2,
	Animation_v0100_continue_00_v0100_continue_00_text_continue_All_out												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_anm_ofs * 3,
	Animation_v0100_continue_00_v0100_continue_00_Reference_text_loop												= Layer_v0100_continue_00_v0100_continue_00_Reference_text | sr_anm_ofs * 1,
	Animation_v0100_continue_00_v0100_continue_00_Reference_kazari_loop												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_anm_ofs * 1,
};

// LXg
enum v0100_continue_00_Casts
{
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 1,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 2,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_base												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 3,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_base_Cast_0181												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 4,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_base_Cast_0182												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 5,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_chara												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 6,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_chara_ami												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 7,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_chara_klu												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 8,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_chara_rng												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 9,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_chara_shz												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 10,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_chara_arl												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 11,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_chara_arl_ef												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 12,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_chara_raf												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 13,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_chara_rul												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 14,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_chara_sig												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 15,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_chara_sig_ten												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 16,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_chara_wch												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 17,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_chara_dra												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 18,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_text												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 19,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_text_no_credit												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 20,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_text_aten												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 21,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_text_aten_aten1												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 22,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_bt												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 23,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_bt_bt_yes												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 24,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_bt_bt_yes_light												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 25,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_bt_bt_yes_light_light_s												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 26,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_bt_bt_no												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 27,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_ef												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 28,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_ef_Cast_0200												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 29,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_kazari												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 30,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_kazari_k_00												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 31,
	Cast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_kazari_k_01												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 32,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 1,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 2,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ko												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 3,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ko_bule_00												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 4,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ko_bule_00_bule_01												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 5,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ko_bule_00_bule_02												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 6,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ko_bule_00_bule_03												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 7,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ko_bule_00_bule_04												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 8,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ko_osds												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 9,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ko_osds_te_ko6												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 10,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ko_osds_te_ko5												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 11,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ko_osds_te_ko4												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 12,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ko_osds_te_ko3												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 13,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ko_osds_te_ko2												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 14,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ko_osds_te_ko1												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 15,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ko_te_ko												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 16,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_n												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 17,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_n_bule_00												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 18,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_n_bule_00_bule_01												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 19,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_n_bule_00_bule_02												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 20,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_n_bule_00_bule_03												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 21,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_n_bule_00_bule_04												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 22,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_n_osds												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 23,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_n_osds_te_00												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 24,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_n_osds_te_01												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 25,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_n_osds_te_02												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 26,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_n_osds_te_03												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 27,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_n_osds_te_04												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 28,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_n_osds_te_05												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 29,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_n_te_ko												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 30,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_te												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 31,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_te_bule_00												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 32,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_te_bule_00_bule_01												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 33,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_te_bule_00_bule_02												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 34,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_te_bule_00_bule_03												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 35,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_te_bule_00_bule_04												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 36,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_te_osds												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 37,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_te_osds_te_00												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 38,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_te_osds_te_01												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 39,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_te_osds_te_02												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 40,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_te_osds_te_03												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 41,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_te_osds_te_04												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 42,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_te_osds_te_05												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 43,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_te_te_ko												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 44,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_i												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 45,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_i_bule_00												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 46,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_i_bule_00_bule_01												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 47,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_i_bule_00_bule_02												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 48,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_i_bule_00_bule_03												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 49,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_i_bule_00_bule_04												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 50,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_i_osds												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 51,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_i_osds_te_00												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 52,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_i_osds_te_01												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 53,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_i_osds_te_02												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 54,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_i_osds_te_03												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 55,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_i_osds_te_04												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 56,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_i_osds_te_05												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 57,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_i_te_ko												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 58,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ni												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 59,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ni_bule_00												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 60,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ni_bule_00_bule_01												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 61,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ni_bule_00_bule_02												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 62,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ni_bule_00_bule_03												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 63,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ni_bule_00_bule_04												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 64,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ni_osds												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 65,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ni_osds_te_00												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 66,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ni_osds_te_01												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 67,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ni_osds_te_02												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 68,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ni_osds_te_03												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 69,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ni_osds_te_04												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 70,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ni_osds_te_05												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 71,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_ni_te_ko												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 72,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_yu												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 73,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_yu_bule_00												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 74,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_yu_bule_00_bule_01												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 75,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_yu_bule_00_bule_02												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 76,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_yu_bule_00_bule_03												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 77,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_yu_bule_00_bule_04												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 78,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_yu_osds												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 79,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_yu_osds_te_00												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 80,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_yu_osds_te_01												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 81,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_yu_osds_te_02												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 82,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_yu_osds_te_03												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 83,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_yu_osds_te_04												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 84,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_yu_osds_te_05												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 85,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_yu_te_ko												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 86,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_line												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 87,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_line_bule_00												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 88,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_line_bule_00_bule_01												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 89,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_line_bule_00_bule_02												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 90,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_line_bule_00_bule_03												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 91,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_line_bule_00_bule_04												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 92,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_line_osds												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 93,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_line_osds_te_00												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 94,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_line_osds_te_01												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 95,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_line_osds_te_02												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 96,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_line_osds_te_03												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 97,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_line_osds_te_04												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 98,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_line_osds_te_05												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 99,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_line_te_ko												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 100,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_hatena												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 101,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_hatena_bule_00												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 102,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_hatena_bule_00_bule_01												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 103,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_hatena_bule_00_bule_02												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 104,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_hatena_bule_00_bule_03												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 105,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_hatena_bule_00_bule_04												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 106,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_hatena_osds												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 107,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_hatena_osds_te_00												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 108,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_hatena_osds_te_01												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 109,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_hatena_osds_te_02												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 110,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_hatena_osds_te_03												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 111,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_hatena_osds_te_04												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 112,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_hatena_osds_te_05												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 113,
	Cast_v0100_continue_00_v0100_continue_00_text_continue_move_point_text_hatena_te_ko												= Layer_v0100_continue_00_v0100_continue_00_text_continue | sr_cst_ofs * 114,
	Cast_v0100_continue_00_v0100_continue_00_Reference_text_move_point												= Layer_v0100_continue_00_v0100_continue_00_Reference_text | sr_cst_ofs * 1,
	Cast_v0100_continue_00_v0100_continue_00_Reference_text_move_point_red_base												= Layer_v0100_continue_00_v0100_continue_00_Reference_text | sr_cst_ofs * 2,
	Cast_v0100_continue_00_v0100_continue_00_Reference_text_move_point_red_base_ptn												= Layer_v0100_continue_00_v0100_continue_00_Reference_text | sr_cst_ofs * 3,
	Cast_v0100_continue_00_v0100_continue_00_Reference_text_move_point_text1												= Layer_v0100_continue_00_v0100_continue_00_Reference_text | sr_cst_ofs * 4,
	Cast_v0100_continue_00_v0100_continue_00_Reference_text_move_point_text1_credit_info												= Layer_v0100_continue_00_v0100_continue_00_Reference_text | sr_cst_ofs * 5,
	Cast_v0100_continue_00_v0100_continue_00_Reference_text_move_point_text1_no_credit												= Layer_v0100_continue_00_v0100_continue_00_Reference_text | sr_cst_ofs * 6,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 1,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_Cast_0236												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 2,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_Cast_0236_kazari_01												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 3,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_Cast_0236_kazari_01_Cast_0208												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 4,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_Cast_0236_kazari_01_Cast_0215												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 5,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_Cast_0236_kazari_01_Cast_0209												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 6,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_Cast_0236_kazari_01_Cast_0210												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 7,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_Cast_0236_kazari_01_Cast_0214												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 8,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_Cast_0236_kazari_03												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 9,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_Cast_0236_kazari_03_Cast_0208												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 10,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_Cast_0236_kazari_03_Cast_0215												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 11,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_Cast_0236_kazari_03_Cast_0209												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 12,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_Cast_0236_kazari_03_Cast_0210												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 13,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_Cast_0236_kazari_03_Cast_0214												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 14,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_Cast_0236_kazari_04												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 15,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_Cast_0236_kazari_04_Cast_0208												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 16,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_Cast_0236_kazari_04_Cast_0215												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 17,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_Cast_0236_kazari_04_Cast_0209												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 18,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_Cast_0236_kazari_04_Cast_0210												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 19,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_Cast_0236_kazari_04_Cast_0214												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 20,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_kazari_02												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 21,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_kazari_02_Cast_0209												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 22,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_kazari_02_Cast_0214												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 23,
	Cast_v0100_continue_00_v0100_continue_00_Reference_kazari_move_point_kazari_02_Cast_0223												= Layer_v0100_continue_00_v0100_continue_00_Reference_kazari | sr_cst_ofs * 24,
};

// t@XLXgĒ`
enum v0100_continue_00_Reference_Casts
{
	RefCast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_ui_text_no_credit												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 20,
	RefCast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_kazari_k_00												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 31,
	RefCast_v0100_continue_00_v0100_continue_00_base_move_point_0_0_kazari_k_01												= Layer_v0100_continue_00_v0100_continue_00_base | sr_cst_ofs * 32,
};

// Aj[VZbg
enum v0100_continue_00_AnimationSets
{
};


// Ro[gNX
class v0100_continue_00Converter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"v0100_continue_00",
	};

	const char* LayerNames[][5] = 
	{
		{
			"base",
			"text_continue",
			"Reference_text",
			"Reference_kazari",
		},
	};

	const char* AnimeNames[][5][5] = 
	{
		{
			{
				"All_in",
				"All_loop",
				"All_out_bt_yes",
				"All_out_bt_no",
			},
			{
				"All_in",
				"All_loop",
				"All_out",
			},
			{
				"loop",
			},
			{
				"loop",
			},
		},
	};

	const char* CastNames[][5][115] = 
	{
		{
			{
				"move_point_0_0",
				"ui",
				"base",
				"Cast_0181",
				"Cast_0182",
				"chara",
				"ami",
				"klu",
				"rng",
				"shz",
				"arl",
				"ef",
				"raf",
				"rul",
				"sig",
				"ten",
				"wch",
				"dra",
				"text",
				"no_credit",
				"aten",
				"aten1",
				"bt",
				"bt_yes",
				"light",
				"light_s",
				"bt_no",
				"ef",
				"Cast_0200",
				"kazari",
				"k_00",
				"k_01",
			},
			{
				"move_point",
				"text",
				"ko",
				"bule_00",
				"bule_01",
				"bule_02",
				"bule_03",
				"bule_04",
				"osds",
				"te_ko6",
				"te_ko5",
				"te_ko4",
				"te_ko3",
				"te_ko2",
				"te_ko1",
				"te_ko",
				"n",
				"bule_00",
				"bule_01",
				"bule_02",
				"bule_03",
				"bule_04",
				"osds",
				"te_00",
				"te_01",
				"te_02",
				"te_03",
				"te_04",
				"te_05",
				"te_ko",
				"te",
				"bule_00",
				"bule_01",
				"bule_02",
				"bule_03",
				"bule_04",
				"osds",
				"te_00",
				"te_01",
				"te_02",
				"te_03",
				"te_04",
				"te_05",
				"te_ko",
				"i",
				"bule_00",
				"bule_01",
				"bule_02",
				"bule_03",
				"bule_04",
				"osds",
				"te_00",
				"te_01",
				"te_02",
				"te_03",
				"te_04",
				"te_05",
				"te_ko",
				"ni",
				"bule_00",
				"bule_01",
				"bule_02",
				"bule_03",
				"bule_04",
				"osds",
				"te_00",
				"te_01",
				"te_02",
				"te_03",
				"te_04",
				"te_05",
				"te_ko",
				"yu",
				"bule_00",
				"bule_01",
				"bule_02",
				"bule_03",
				"bule_04",
				"osds",
				"te_00",
				"te_01",
				"te_02",
				"te_03",
				"te_04",
				"te_05",
				"te_ko",
				"line",
				"bule_00",
				"bule_01",
				"bule_02",
				"bule_03",
				"bule_04",
				"osds",
				"te_00",
				"te_01",
				"te_02",
				"te_03",
				"te_04",
				"te_05",
				"te_ko",
				"hatena",
				"bule_00",
				"bule_01",
				"bule_02",
				"bule_03",
				"bule_04",
				"osds",
				"te_00",
				"te_01",
				"te_02",
				"te_03",
				"te_04",
				"te_05",
				"te_ko",
			},
			{
				"move_point",
				"red_base",
				"ptn",
				"text1",
				"credit_info",
				"no_credit",
			},
			{
				"move_point",
				"Cast_0236",
				"kazari_01",
				"Cast_0208",
				"Cast_0215",
				"Cast_0209",
				"Cast_0210",
				"Cast_0214",
				"kazari_03",
				"Cast_0208",
				"Cast_0215",
				"Cast_0209",
				"Cast_0210",
				"Cast_0214",
				"kazari_04",
				"Cast_0208",
				"Cast_0215",
				"Cast_0209",
				"Cast_0210",
				"Cast_0214",
				"kazari_02",
				"Cast_0209",
				"Cast_0214",
				"Cast_0223",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

