///------------------------------------------------------------------------
/// @file   v0100_matching_08.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_v0100_matching_08_H__ )
#define __SR_v0100_matching_08_H__

namespace surfride { 
namespace header { 

// V[
enum v0100_matching_08_Scenes
{
	Scene_v0100_matching_08_v0100_matching_08												= sr_scn_ofs * 1,
};

// C[
enum v0100_matching_08_Layers
{
	Layer_v0100_matching_08_v0100_matching_08_BG												= Scene_v0100_matching_08_v0100_matching_08 | sr_lyr_ofs * 1,
	Layer_v0100_matching_08_v0100_matching_08_info_space												= Scene_v0100_matching_08_v0100_matching_08 | sr_lyr_ofs * 2,
	Layer_v0100_matching_08_v0100_matching_08_puyo_training												= Scene_v0100_matching_08_v0100_matching_08 | sr_lyr_ofs * 3,
	Layer_v0100_matching_08_v0100_matching_08_info_space1												= Scene_v0100_matching_08_v0100_matching_08 | sr_lyr_ofs * 4,
};

// Aj[V
enum v0100_matching_08_Animations
{
	Animation_v0100_matching_08_v0100_matching_08_BG_all_in												= Layer_v0100_matching_08_v0100_matching_08_BG | sr_anm_ofs * 1,
	Animation_v0100_matching_08_v0100_matching_08_BG_loop												= Layer_v0100_matching_08_v0100_matching_08_BG | sr_anm_ofs * 2,
	Animation_v0100_matching_08_v0100_matching_08_BG_all_out												= Layer_v0100_matching_08_v0100_matching_08_BG | sr_anm_ofs * 3,
	Animation_v0100_matching_08_v0100_matching_08_info_space_all_in												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_anm_ofs * 1,
	Animation_v0100_matching_08_v0100_matching_08_info_space_loop												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_anm_ofs * 2,
	Animation_v0100_matching_08_v0100_matching_08_info_space_all_out												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_anm_ofs * 3,
	Animation_v0100_matching_08_v0100_matching_08_puyo_training_all_in												= Layer_v0100_matching_08_v0100_matching_08_puyo_training | sr_anm_ofs * 1,
	Animation_v0100_matching_08_v0100_matching_08_puyo_training_loop												= Layer_v0100_matching_08_v0100_matching_08_puyo_training | sr_anm_ofs * 2,
	Animation_v0100_matching_08_v0100_matching_08_puyo_training_all_out												= Layer_v0100_matching_08_v0100_matching_08_puyo_training | sr_anm_ofs * 3,
	Animation_v0100_matching_08_v0100_matching_08_info_space1_all_in												= Layer_v0100_matching_08_v0100_matching_08_info_space1 | sr_anm_ofs * 1,
	Animation_v0100_matching_08_v0100_matching_08_info_space1_loop												= Layer_v0100_matching_08_v0100_matching_08_info_space1 | sr_anm_ofs * 2,
	Animation_v0100_matching_08_v0100_matching_08_info_space1_all_out												= Layer_v0100_matching_08_v0100_matching_08_info_space1 | sr_anm_ofs * 3,
};

// LXg
enum v0100_matching_08_Casts
{
	Cast_v0100_matching_08_v0100_matching_08_BG_move_point_0_0												= Layer_v0100_matching_08_v0100_matching_08_BG | sr_cst_ofs * 1,
	Cast_v0100_matching_08_v0100_matching_08_BG_move_point_0_0_point												= Layer_v0100_matching_08_v0100_matching_08_BG | sr_cst_ofs * 2,
	Cast_v0100_matching_08_v0100_matching_08_BG_move_point_0_0_point_bg												= Layer_v0100_matching_08_v0100_matching_08_BG | sr_cst_ofs * 3,
	Cast_v0100_matching_08_v0100_matching_08_info_space_move_point_0_0												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_cst_ofs * 1,
	Cast_v0100_matching_08_v0100_matching_08_info_space_move_point_0_0_point												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_cst_ofs * 2,
	Cast_v0100_matching_08_v0100_matching_08_info_space_move_point_0_0_point_base												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_cst_ofs * 3,
	Cast_v0100_matching_08_v0100_matching_08_info_space_move_point_0_0_point_base_p1												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_cst_ofs * 4,
	Cast_v0100_matching_08_v0100_matching_08_info_space_move_point_0_0_point_base_p2												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_cst_ofs * 5,
	Cast_v0100_matching_08_v0100_matching_08_info_space_move_point_0_0_point_point_1												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_cst_ofs * 6,
	Cast_v0100_matching_08_v0100_matching_08_info_space_move_point_0_0_point_point_1_p1												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_cst_ofs * 7,
	Cast_v0100_matching_08_v0100_matching_08_info_space_move_point_0_0_point_point_1_cap_p1												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_cst_ofs * 8,
	Cast_v0100_matching_08_v0100_matching_08_info_space_move_point_0_0_point_point_1_g_p1												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_cst_ofs * 9,
	Cast_v0100_matching_08_v0100_matching_08_info_space_move_point_0_0_point_point_2												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_cst_ofs * 10,
	Cast_v0100_matching_08_v0100_matching_08_info_space_move_point_0_0_point_point_2_p2												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_cst_ofs * 11,
	Cast_v0100_matching_08_v0100_matching_08_info_space_move_point_0_0_point_point_2_cap_p2												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_cst_ofs * 12,
	Cast_v0100_matching_08_v0100_matching_08_info_space_move_point_0_0_point_point_2_g_p2												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_cst_ofs * 13,
	Cast_v0100_matching_08_v0100_matching_08_info_space_move_point_0_0_point_info												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_cst_ofs * 14,
	Cast_v0100_matching_08_v0100_matching_08_info_space_move_point_0_0_point_info_base												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_cst_ofs * 15,
	Cast_v0100_matching_08_v0100_matching_08_info_space_move_point_0_0_point_info_info												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_cst_ofs * 16,
	Cast_v0100_matching_08_v0100_matching_08_info_space_move_point_0_0_point_info_info_info_00												= Layer_v0100_matching_08_v0100_matching_08_info_space | sr_cst_ofs * 17,
	Cast_v0100_matching_08_v0100_matching_08_puyo_training_move_point_0_0												= Layer_v0100_matching_08_v0100_matching_08_puyo_training | sr_cst_ofs * 1,
	Cast_v0100_matching_08_v0100_matching_08_puyo_training_move_point_0_0_puto_zoon												= Layer_v0100_matching_08_v0100_matching_08_puyo_training | sr_cst_ofs * 2,
	Cast_v0100_matching_08_v0100_matching_08_puyo_training_move_point_0_0_puto_zoon_base												= Layer_v0100_matching_08_v0100_matching_08_puyo_training | sr_cst_ofs * 3,
	Cast_v0100_matching_08_v0100_matching_08_puyo_training_move_point_0_0_puto_zoon_game_dummy												= Layer_v0100_matching_08_v0100_matching_08_puyo_training | sr_cst_ofs * 4,
	Cast_v0100_matching_08_v0100_matching_08_puyo_training_move_point_0_0_puto_zoon_caption												= Layer_v0100_matching_08_v0100_matching_08_puyo_training | sr_cst_ofs * 5,
	Cast_v0100_matching_08_v0100_matching_08_info_space1_move_point_0_0												= Layer_v0100_matching_08_v0100_matching_08_info_space1 | sr_cst_ofs * 1,
	Cast_v0100_matching_08_v0100_matching_08_info_space1_move_point_0_0_aco												= Layer_v0100_matching_08_v0100_matching_08_info_space1 | sr_cst_ofs * 2,
	Cast_v0100_matching_08_v0100_matching_08_info_space1_move_point_0_0_aco_aco_reference												= Layer_v0100_matching_08_v0100_matching_08_info_space1 | sr_cst_ofs * 3,
	Cast_v0100_matching_08_v0100_matching_08_info_space1_move_point_0_0_aco_txt_navi												= Layer_v0100_matching_08_v0100_matching_08_info_space1 | sr_cst_ofs * 4,
};

// t@XLXgĒ`
enum v0100_matching_08_Reference_Casts
{
};

// Aj[VZbg
enum v0100_matching_08_AnimationSets
{
	AnimationSet_v0100_matching_08_v0100_matching_08_SHOUKAN_01												= sr_sol_ofs * 1 | Scene_v0100_matching_08_v0100_matching_08 | sr_set_ofs * 1,
	AnimationSet_v0100_matching_08_v0100_matching_08_SHOUKAN_02												= sr_sol_ofs * 1 | Scene_v0100_matching_08_v0100_matching_08 | sr_set_ofs * 2,
	AnimationSet_v0100_matching_08_v0100_matching_08_SHOUKAN_03												= sr_sol_ofs * 1 | Scene_v0100_matching_08_v0100_matching_08 | sr_set_ofs * 3,
	AnimationSet_v0100_matching_08_v0100_matching_08_SHOUKAN_04												= sr_sol_ofs * 1 | Scene_v0100_matching_08_v0100_matching_08 | sr_set_ofs * 4,
	AnimationSet_v0100_matching_08_v0100_matching_08_SHOUKAN_05												= sr_sol_ofs * 1 | Scene_v0100_matching_08_v0100_matching_08 | sr_set_ofs * 5,
	AnimationSet_v0100_matching_08_v0100_matching_08_SHOUKAN_06												= sr_sol_ofs * 1 | Scene_v0100_matching_08_v0100_matching_08 | sr_set_ofs * 6,
	AnimationSet_v0100_matching_08_v0100_matching_08_SHOUKAN_07												= sr_sol_ofs * 1 | Scene_v0100_matching_08_v0100_matching_08 | sr_set_ofs * 7,
	AnimationSet_v0100_matching_08_v0100_matching_08_SHOUKAN_08												= sr_sol_ofs * 1 | Scene_v0100_matching_08_v0100_matching_08 | sr_set_ofs * 8,
	AnimationSet_v0100_matching_08_v0100_matching_08_SHOUKAN_09												= sr_sol_ofs * 1 | Scene_v0100_matching_08_v0100_matching_08 | sr_set_ofs * 9,
	AnimationSet_v0100_matching_08_v0100_matching_08_SHOUKAN_10												= sr_sol_ofs * 1 | Scene_v0100_matching_08_v0100_matching_08 | sr_set_ofs * 10,
};


// Ro[gNX
class v0100_matching_08Converter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"v0100_matching_08",
	};

	const char* LayerNames[][5] = 
	{
		{
			"BG",
			"info_space",
			"puyo_training",
			"info_space1",
		},
	};

	const char* AnimeNames[][5][4] = 
	{
		{
			{
				"all_in",
				"loop",
				"all_out",
			},
			{
				"all_in",
				"loop",
				"all_out",
			},
			{
				"all_in",
				"loop",
				"all_out",
			},
			{
				"all_in",
				"loop",
				"all_out",
			},
		},
	};

	const char* CastNames[][5][18] = 
	{
		{
			{
				"move_point_0_0",
				"point",
				"bg",
			},
			{
				"move_point_0_0",
				"point",
				"base",
				"base_p1",
				"base_p2",
				"point_1",
				"p1",
				"cap_p1",
				"g_p1",
				"point_2",
				"p2",
				"cap_p2",
				"g_p2",
				"point_info",
				"base",
				"info",
				"info_00",
			},
			{
				"move_point_0_0",
				"puto_zoon",
				"base",
				"game_dummy",
				"caption",
			},
			{
				"move_point_0_0",
				"aco",
				"aco_reference",
				"txt_navi",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

