///------------------------------------------------------------------------
/// @file   v0100_reference_aco_00.h
/// @brief  GNX|[^[t@C
/// @author SurfrideExporter
/// 
/// Copyright(C) SEGA
///------------------------------------------------------------------------

#include "surfride/Def.h"

#if !defined( __SR_v0100_reference_aco_00_H__ )
#define __SR_v0100_reference_aco_00_H__

namespace surfride { 
namespace header { 

// V[
enum v0100_reference_aco_00_Scenes
{
	Scene_v0100_reference_aco_00_v0100_reference_aco_00												= sr_scn_ofs * 1,
};

// C[
enum v0100_reference_aco_00_Layers
{
	Layer_v0100_reference_aco_00_v0100_reference_aco_00_aco_kime												= Scene_v0100_reference_aco_00_v0100_reference_aco_00 | sr_lyr_ofs * 1,
	Layer_v0100_reference_aco_00_v0100_reference_aco_00_aco_stand												= Scene_v0100_reference_aco_00_v0100_reference_aco_00 | sr_lyr_ofs * 2,
};

// Aj[V
enum v0100_reference_aco_00_Animations
{
	Animation_v0100_reference_aco_00_v0100_reference_aco_00_aco_kime_loop												= Layer_v0100_reference_aco_00_v0100_reference_aco_00_aco_kime | sr_anm_ofs * 1,
	Animation_v0100_reference_aco_00_v0100_reference_aco_00_aco_stand_loop												= Layer_v0100_reference_aco_00_v0100_reference_aco_00_aco_stand | sr_anm_ofs * 1,
};

// LXg
enum v0100_reference_aco_00_Casts
{
	Cast_v0100_reference_aco_00_v0100_reference_aco_00_aco_kime_move_point_0_0												= Layer_v0100_reference_aco_00_v0100_reference_aco_00_aco_kime | sr_cst_ofs * 1,
	Cast_v0100_reference_aco_00_v0100_reference_aco_00_aco_kime_move_point_0_0_aco_kime												= Layer_v0100_reference_aco_00_v0100_reference_aco_00_aco_kime | sr_cst_ofs * 2,
	Cast_v0100_reference_aco_00_v0100_reference_aco_00_aco_kime_move_point_0_0_aco_kime_tale												= Layer_v0100_reference_aco_00_v0100_reference_aco_00_aco_kime | sr_cst_ofs * 3,
	Cast_v0100_reference_aco_00_v0100_reference_aco_00_aco_kime_move_point_0_0_aco_kime_body												= Layer_v0100_reference_aco_00_v0100_reference_aco_00_aco_kime | sr_cst_ofs * 4,
	Cast_v0100_reference_aco_00_v0100_reference_aco_00_aco_kime_move_point_0_0_aco_kime_body_face												= Layer_v0100_reference_aco_00_v0100_reference_aco_00_aco_kime | sr_cst_ofs * 5,
	Cast_v0100_reference_aco_00_v0100_reference_aco_00_aco_stand_move_point_0_0												= Layer_v0100_reference_aco_00_v0100_reference_aco_00_aco_stand | sr_cst_ofs * 1,
	Cast_v0100_reference_aco_00_v0100_reference_aco_00_aco_stand_move_point_0_0_aco_stand												= Layer_v0100_reference_aco_00_v0100_reference_aco_00_aco_stand | sr_cst_ofs * 2,
	Cast_v0100_reference_aco_00_v0100_reference_aco_00_aco_stand_move_point_0_0_aco_stand_body												= Layer_v0100_reference_aco_00_v0100_reference_aco_00_aco_stand | sr_cst_ofs * 3,
	Cast_v0100_reference_aco_00_v0100_reference_aco_00_aco_stand_move_point_0_0_aco_stand_arm												= Layer_v0100_reference_aco_00_v0100_reference_aco_00_aco_stand | sr_cst_ofs * 4,
	Cast_v0100_reference_aco_00_v0100_reference_aco_00_aco_stand_move_point_0_0_aco_stand_teel												= Layer_v0100_reference_aco_00_v0100_reference_aco_00_aco_stand | sr_cst_ofs * 5,
	Cast_v0100_reference_aco_00_v0100_reference_aco_00_aco_stand_move_point_0_0_aco_stand_head												= Layer_v0100_reference_aco_00_v0100_reference_aco_00_aco_stand | sr_cst_ofs * 6,
	Cast_v0100_reference_aco_00_v0100_reference_aco_00_aco_stand_move_point_0_0_aco_stand_leg_0												= Layer_v0100_reference_aco_00_v0100_reference_aco_00_aco_stand | sr_cst_ofs * 7,
	Cast_v0100_reference_aco_00_v0100_reference_aco_00_aco_stand_move_point_0_0_aco_stand_reg_1												= Layer_v0100_reference_aco_00_v0100_reference_aco_00_aco_stand | sr_cst_ofs * 8,
};

// t@XLXgĒ`
enum v0100_reference_aco_00_Reference_Casts
{
};

// Aj[VZbg
enum v0100_reference_aco_00_AnimationSets
{
	AnimationSet_v0100_reference_aco_00_v0100_reference_aco_00_SHOUKAN_01												= sr_sol_ofs * 1 | Scene_v0100_reference_aco_00_v0100_reference_aco_00 | sr_set_ofs * 1,
	AnimationSet_v0100_reference_aco_00_v0100_reference_aco_00_SHOUKAN_02												= sr_sol_ofs * 1 | Scene_v0100_reference_aco_00_v0100_reference_aco_00 | sr_set_ofs * 2,
	AnimationSet_v0100_reference_aco_00_v0100_reference_aco_00_SHOUKAN_03												= sr_sol_ofs * 1 | Scene_v0100_reference_aco_00_v0100_reference_aco_00 | sr_set_ofs * 3,
	AnimationSet_v0100_reference_aco_00_v0100_reference_aco_00_SHOUKAN_04												= sr_sol_ofs * 1 | Scene_v0100_reference_aco_00_v0100_reference_aco_00 | sr_set_ofs * 4,
	AnimationSet_v0100_reference_aco_00_v0100_reference_aco_00_SHOUKAN_05												= sr_sol_ofs * 1 | Scene_v0100_reference_aco_00_v0100_reference_aco_00 | sr_set_ofs * 5,
	AnimationSet_v0100_reference_aco_00_v0100_reference_aco_00_SHOUKAN_06												= sr_sol_ofs * 1 | Scene_v0100_reference_aco_00_v0100_reference_aco_00 | sr_set_ofs * 6,
	AnimationSet_v0100_reference_aco_00_v0100_reference_aco_00_SHOUKAN_07												= sr_sol_ofs * 1 | Scene_v0100_reference_aco_00_v0100_reference_aco_00 | sr_set_ofs * 7,
	AnimationSet_v0100_reference_aco_00_v0100_reference_aco_00_SHOUKAN_08												= sr_sol_ofs * 1 | Scene_v0100_reference_aco_00_v0100_reference_aco_00 | sr_set_ofs * 8,
	AnimationSet_v0100_reference_aco_00_v0100_reference_aco_00_SHOUKAN_09												= sr_sol_ofs * 1 | Scene_v0100_reference_aco_00_v0100_reference_aco_00 | sr_set_ofs * 9,
	AnimationSet_v0100_reference_aco_00_v0100_reference_aco_00_SHOUKAN_10												= sr_sol_ofs * 1 | Scene_v0100_reference_aco_00_v0100_reference_aco_00 | sr_set_ofs * 10,
};


// Ro[gNX
class v0100_reference_aco_00Converter : public SrHeaderConverter
{
const SrDataNameStr& convert( tea::u32 name )
{
	static SrDataNameStr result = {};
	SrDataName nameData;
	nameData._raw = name;
	
	const char* SceneNames[] = 
	{
		"v0100_reference_aco_00",
	};

	const char* LayerNames[][3] = 
	{
		{
			"aco_kime",
			"aco_stand",
		},
	};

	const char* AnimeNames[][3][2] = 
	{
		{
			{
				"loop",
			},
			{
				"loop",
			},
		},
	};

	const char* CastNames[][3][9] = 
	{
		{
			{
				"move_point_0_0",
				"aco_kime",
				"tale",
				"body",
				"face",
			},
			{
				"move_point_0_0",
				"aco_stand",
				"body",
				"arm",
				"teel",
				"head",
				"leg_0",
				"reg_1",
			},
		},
	};

	result._pSceneName		= SceneNames[ nameData._bit._scene ];
	result._pLayerName		= LayerNames[ nameData._bit._scene ][ nameData._bit._layer ];
	result._pAnimationName	= AnimeNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._animation ];
	result._pCastName		= CastNames[ nameData._bit._scene ][ nameData._bit._layer ][ nameData._bit._cast ];

	return result;
}
};
}
}

#endif

